<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class C_sys_stagiaire extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('sys/M_sys_profil', 'profil');
        $this->load->model('M_personnel', 'personnel');
        $this->load->model('M_structure', 'structure');
        $this->load->helper('string');


        //$this->load->model('M_table_param');
    }

    public function index()
    {

        $user_data = $this->personnel->get_stagiaire();
        $data['all_data'] = $user_data;
        $structure = $this->structure->get_data();
        $data['select_code_str'] = create_select_list($structure, 'code_str', 'libelle');
        $this->load->view('sys/V_sys_stagiaire', $data);
    }




    public function save_stagiaire()
    {
        if ($this->input->post('id') != '')
        {
            $this->personnel->id = $this->input->post('id');
            $this->personnel->ien = $this->input->post('ien');
            $this->personnel->prenom = $this->input->post('prenom');
            $this->personnel->nom = $this->input->post('nom');
            $this->personnel->code_str = $this->input->post('code_str');
            $this->personnel->email_pro = $this->input ->post('email_pro');
            echo json_encode($this->personnel->save(), JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP);
        }
        else{
            $ien = generer_ien_stg();
            $this->personnel->ien = $ien;
            $this->personnel->prenom = $this->input->post('prenom');
            $this->personnel->nom = $this->input->post('nom');
            $this->personnel->code_str = $this->input->post('code_str');
            $this->personnel->email_pro = $this->input ->post('email_pro');
            $this->personnel->etat = 1;
            echo json_encode($this->personnel->save(), JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP);
        }
    }

    public function get_record()
    {
        $args =func_get_args();
        $this->personnel->id = $args[0];
        $this->personnel->get_record();
        echo json_encode($this->personnel, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP);
    }


    public function delete()
    {
        $args = func_get_args();
        $this->personnel->id = $args[0];
        $this->personnel->id = $args[0];
        $this->personnel->delete();
        echo json_encode($this->personnel->delete(), JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP);
    }


}
