/*
 Highstock JS v7.1.3 (2019-08-14)

 Highstock as a plugin for Highcharts

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(p){"object"===typeof module&&module.exports?(p["default"]=p,module.exports=p):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(G){p(G);p.Highcharts=G;return p}):p("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(p){function G(b,n,p,w){b.hasOwnProperty(n)||(b[n]=w.apply(null,p))}p=p?p._modules:{};G(p,"parts/Scrollbar.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(b,n){function p(a,f,h){this.init(a,f,h)}var w=n.defined,
B=b.addEvent;n=b.Axis;var D=b.correctFloat,z=b.defaultOptions,y=b.destroyObjectProperties,k=b.fireEvent,A=b.hasTouch,e=b.merge,r=b.pick,E=b.removeEvent,q,l={height:b.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",
trackBorderColor:"#f2f2f2",trackBorderWidth:1};z.scrollbar=e(!0,l,z.scrollbar);b.swapXY=q=function(a,f){var h=a.length;if(f)for(f=0;f<h;f+=3){var x=a[f+1];a[f+1]=a[f+2];a[f+2]=x}return a};p.prototype={init:function(a,f,h){this.scrollbarButtons=[];this.renderer=a;this.userOptions=f;this.options=e(l,f);this.chart=h;this.size=r(this.options.size,this.options.height);f.enabled&&(this.render(),this.initEvents(),this.addEvents())},render:function(){var a=this.renderer,f=this.options,h=this.size,x=this.chart.styledMode,
d;this.group=d=a.g("scrollbar").attr({zIndex:f.zIndex,translateY:-99999}).add();this.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:f.trackBorderRadius||0,height:h,width:h}).add(d);x||this.track.attr({fill:f.trackBackgroundColor,stroke:f.trackBorderColor,"stroke-width":f.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=a.g().add(d);this.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:h,
width:h,r:f.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=a.path(q(["M",-3,h/4,"L",-3,2*h/3,"M",0,h/4,"L",0,2*h/3,"M",3,h/4,"L",3,2*h/3],f.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);x||(this.scrollbar.attr({fill:f.barBackgroundColor,stroke:f.barBorderColor,"stroke-width":f.barBorderWidth}),this.scrollbarRifles.attr({stroke:f.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%
2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)},position:function(a,f,h,x){var d=this.options.vertical,m=0,u=this.rendered?"animate":"attr";this.x=a;this.y=f+this.trackBorderWidth;this.width=h;this.xOffset=this.height=x;this.yOffset=m;d?(this.width=this.yOffset=h=m=this.size,this.xOffset=f=0,this.barWidth=x-2*h,this.x=a+=this.options.margin):(this.height=this.xOffset=x=f=this.size,this.barWidth=h-2*x,this.y+=this.options.margin);this.group[u]({translateX:a,
translateY:this.y});this.track[u]({width:h,height:x});this.scrollbarButtons[1][u]({translateX:d?0:h-f,translateY:d?x-m:0})},drawScrollbarButton:function(a){var f=this.renderer,h=this.scrollbarButtons,x=this.options,d=this.size;var m=f.g().add(this.group);h.push(m);m=f.rect().addClass("highcharts-scrollbar-button").add(m);this.chart.styledMode||m.attr({stroke:x.buttonBorderColor,"stroke-width":x.buttonBorderWidth,fill:x.buttonBackgroundColor});m.attr(m.crisp({x:-.5,y:-.5,width:d+1,height:d+1,r:x.buttonBorderRadius},
m.strokeWidth()));m=f.path(q(["M",d/2+(a?-1:1),d/2-3,"L",d/2+(a?-1:1),d/2+3,"L",d/2+(a?2:-2),d/2],x.vertical)).addClass("highcharts-scrollbar-arrow").add(h[a]);this.chart.styledMode||m.attr({fill:x.buttonArrowColor})},setRange:function(a,f){var h=this.options,x=h.vertical,d=h.minWidth,m=this.barWidth,u,e=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(w(m)){a=Math.max(a,0);var c=Math.ceil(m*a);this.calculatedWidth=u=D(m*Math.min(f,1)-c);u<
d&&(c=(m-d+u)*a,u=d);d=Math.floor(c+this.xOffset+this.yOffset);m=u/2-.5;this.from=a;this.to=f;x?(this.scrollbarGroup[e]({translateY:d}),this.scrollbar[e]({height:u}),this.scrollbarRifles[e]({translateY:m}),this.scrollbarTop=d,this.scrollbarLeft=0):(this.scrollbarGroup[e]({translateX:d}),this.scrollbar[e]({width:u}),this.scrollbarRifles[e]({translateX:m}),this.scrollbarLeft=d,this.scrollbarTop=0);12>=u?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===h.showFull&&(0>=a&&1<=f?this.group.hide():
this.group.show());this.rendered=!0}},initEvents:function(){var a=this;a.mouseMoveHandler=function(f){var h=a.chart.pointer.normalize(f),e=a.options.vertical?"chartY":"chartX",d=a.initPositions;!a.grabbedCenter||f.touches&&0===f.touches[0][e]||(h=a.cursorToScrollbarPosition(h)[e],e=a[e],e=h-e,a.hasDragged=!0,a.updatePosition(d[0]+e,d[1]+e),a.hasDragged&&k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:f.type,DOMEvent:f}))};a.mouseUpHandler=function(f){a.hasDragged&&k(a,"changed",{from:a.from,
to:a.to,trigger:"scrollbar",DOMType:f.type,DOMEvent:f});a.grabbedCenter=a.hasDragged=a.chartX=a.chartY=null};a.mouseDownHandler=function(f){f=a.chart.pointer.normalize(f);f=a.cursorToScrollbarPosition(f);a.chartX=f.chartX;a.chartY=f.chartY;a.initPositions=[a.from,a.to];a.grabbedCenter=!0};a.buttonToMinClick=function(f){var h=D(a.to-a.from)*a.options.step;a.updatePosition(D(a.from-h),D(a.to-h));k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:f})};a.buttonToMaxClick=function(f){var h=
(a.to-a.from)*a.options.step;a.updatePosition(a.from+h,a.to+h);k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:f})};a.trackClick=function(f){var h=a.chart.pointer.normalize(f),e=a.to-a.from,d=a.y+a.scrollbarTop,m=a.x+a.scrollbarLeft;a.options.vertical&&h.chartY>d||!a.options.vertical&&h.chartX>m?a.updatePosition(a.from+e,a.to+e):a.updatePosition(a.from-e,a.to-e);k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:f})}},cursorToScrollbarPosition:function(a){var f=this.options;
f=f.minWidth>this.calculatedWidth?f.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-f),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-f)}},updatePosition:function(a,f){1<f&&(a=D(1-D(f-a)),f=1);0>a&&(f=D(f-a),a=0);this.from=a;this.to=f},update:function(a){this.destroy();this.init(this.chart.renderer,e(!0,this.options,a),this.chart)},addEvents:function(){var a=this.options.inverted?[1,0]:[0,1],f=this.scrollbarButtons,h=this.scrollbarGroup.element,e=this.mouseDownHandler,
d=this.mouseMoveHandler,m=this.mouseUpHandler;a=[[f[a[0]].element,"click",this.buttonToMinClick],[f[a[1]].element,"click",this.buttonToMaxClick],[this.track.element,"click",this.trackClick],[h,"mousedown",e],[h.ownerDocument,"mousemove",d],[h.ownerDocument,"mouseup",m]];A&&a.push([h,"touchstart",e],[h.ownerDocument,"touchmove",d],[h.ownerDocument,"touchend",m]);a.forEach(function(a){B.apply(null,a)});this._events=a},removeEvents:function(){this._events.forEach(function(a){E.apply(null,a)});this._events.length=
0},destroy:function(){var a=this.chart.scroller;this.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(a){this[a]&&this[a].destroy&&(this[a]=this[a].destroy())},this);a&&this===a.scrollbar&&(a.scrollbar=null,y(a.scrollbarButtons))}};b.Scrollbar||(B(n,"afterInit",function(){var a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new p(a.chart.renderer,
a.options.scrollbar,a.chart),B(a.scrollbar,"changed",function(f){var h=Math.min(r(a.options.min,a.min),a.min,a.dataMin),e=Math.max(r(a.options.max,a.max),a.max,a.dataMax)-h;if(a.horiz&&!a.reversed||!a.horiz&&a.reversed){var d=h+e*this.to;h+=e*this.from}else d=h+e*(1-this.from),h+=e*(1-this.to);r(this.options.liveRedraw,b.svg&&!b.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===f.DOMType||!w(f.DOMType)?a.setExtremes(h,d,!0,"mousemove"!==f.DOMType,f):this.setRange(this.from,this.to)}))}),B(n,"afterRender",
function(){var a=Math.min(r(this.options.min,this.min),this.min,r(this.dataMin,this.min)),f=Math.max(r(this.options.max,this.max),this.max,r(this.dataMax,this.max)),h=this.scrollbar,e=this.axisTitleMargin+(this.titleOffset||0),d=this.chart.scrollbarsOffsets,m=this.options.margin||0;h&&(this.horiz?(this.opposite||(d[1]+=e),h.position(this.left,this.top+this.height+2+d[1]-(this.opposite?m:0),this.width,this.height),this.opposite||(d[1]+=m),e=1):(this.opposite&&(d[0]+=e),h.position(this.left+this.width+
2+d[0]-(this.opposite?0:m),this.top,this.width,this.height),this.opposite&&(d[0]+=m),e=0),d[e]+=h.size+h.options.margin,isNaN(a)||isNaN(f)||!w(this.min)||!w(this.max)||this.min===this.max?h.setRange(0,1):(d=(this.min-a)/(f-a),a=(this.max-a)/(f-a),this.horiz&&!this.reversed||!this.horiz&&this.reversed?h.setRange(d,a):h.setRange(1-a,1-d)))}),B(n,"afterGetOffset",function(){var a=this.horiz?2:1,f=this.scrollbar;f&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[a]+=f.size+f.options.margin)}),
b.Scrollbar=p)});G(p,"parts/Navigator.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(b,n){function p(c){this.init(c)}var w=n.defined,B=n.erase,D=n.isArray,z=n.isNumber,y=n.splat,k=b.addEvent,A=b.Axis;n=b.Chart;var e=b.color,r=b.defaultOptions,E=b.destroyObjectProperties,q=b.extend,l=b.hasTouch,a=b.isTouchDevice,f=b.merge,h=b.pick,x=b.removeEvent,d=b.Scrollbar,m=b.Series,u=function(c){for(var t=[],g=1;g<arguments.length;g++)t[g-1]=arguments[g];t=[].filter.call(t,z);if(t.length)return Math[c].apply(0,
t)};var v=void 0===b.seriesTypes.areaspline?"line":"areaspline";q(r,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:v,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,smoothed:!0,units:[["millisecond",[1,
2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},pointRange:0,threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",
style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});b.Renderer.prototype.symbols["navigator-handle"]=function(c,t,g,a,d){c=d.width/2;t=Math.round(c/3)+.5;d=d.height;return["M",-c-1,.5,"L",c,.5,"L",c,d+.5,"L",-c-1,d+.5,"L",-c-1,.5,"M",-t,4,"L",-t,d-3,"M",t-1,4,"L",t-1,d-3]};A.prototype.toFixedRange=function(c,
t,g,a){var d=this.chart&&this.chart.fixedRange;c=h(g,this.translate(c,!0,!this.horiz));t=h(a,this.translate(t,!0,!this.horiz));g=d&&(t-c)/d;.7<g&&1.3>g&&(a?c=t-d:t=c+d);z(c)&&z(t)||(c=t=void 0);return{min:c,max:t}};p.prototype={drawHandle:function(c,t,g,a){var d=this.navigatorOptions.handles.height;this.handles[t][a](g?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(c,10)+.5-d)}:{translateX:Math.round(this.left+parseInt(c,10)),translateY:Math.round(this.top+
this.height/2-d/2-1)})},drawOutline:function(c,t,g,a){var d=this.navigatorOptions.maskInside,C=this.outline.strokeWidth(),f=C/2;C=C%2/2;var e=this.outlineHeight,m=this.scrollbarHeight,u=this.size,h=this.left-m,b=this.top;g?(h-=f,g=b+t+C,t=b+c+C,c=["M",h+e,b-m-C,"L",h+e,g,"L",h,g,"L",h,t,"L",h+e,t,"L",h+e,b+u+m].concat(d?["M",h+e,g-f,"L",h+e,t+f]:[])):(c+=h+m-C,t+=h+m-C,b+=f,c=["M",h,b,"L",c,b,"L",c,b+e,"L",t,b+e,"L",t,b,"L",h+u+2*m,b].concat(d?["M",c-f,b,"L",t+f,b]:[]));this.outline[a]({d:c})},drawMasks:function(c,
t,g,a){var d=this.left,C=this.top,f=this.height;if(g){var h=[d,d,d];var e=[C,C+c,C+t];var m=[f,f,f];var u=[c,t-c,this.size-t]}else h=[d,d+c,d+t],e=[C,C,C],m=[c,t-c,this.size-t],u=[f,f,f];this.shades.forEach(function(c,g){c[a]({x:h[g],y:e[g],width:m[g],height:u[g]})})},renderElements:function(){var c=this,t=c.navigatorOptions,g=t.maskInside,d=c.chart,a=d.renderer,f,h={cursor:d.inverted?"ns-resize":"ew-resize"};c.navigatorGroup=f=a.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!g,g,!g].forEach(function(g,
F){c.shades[F]=a.rect().addClass("highcharts-navigator-mask"+(1===F?"-inside":"-outside")).add(f);d.styledMode||c.shades[F].attr({fill:g?t.maskFill:"rgba(0,0,0,0)"}).css(1===F&&h)});c.outline=a.path().addClass("highcharts-navigator-outline").add(f);d.styledMode||c.outline.attr({"stroke-width":t.outlineWidth,stroke:t.outlineColor});t.handles.enabled&&[0,1].forEach(function(g){t.handles.inverted=d.inverted;c.handles[g]=a.symbol(t.handles.symbols[g],-t.handles.width/2-1,0,t.handles.width,t.handles.height,
t.handles);c.handles[g].attr({zIndex:7-g}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][g]).add(f);if(!d.styledMode){var F=t.handles;c.handles[g].attr({fill:F.backgroundColor,stroke:F.borderColor,"stroke-width":F.lineWidth}).css(h)}})},update:function(c){(this.series||[]).forEach(function(c){c.baseSeries&&delete c.baseSeries.navigatorSeries});this.destroy();f(!0,this.chart.options.navigator,this.options,c);this.init(this.chart)},render:function(c,t,g,d){var a=
this.chart,f=this.scrollbarHeight,C,e=this.xAxis;var m=e.fake?a.xAxis[0]:e;var u=this.navigatorEnabled,v,l=this.rendered;var r=a.inverted;var x=a.xAxis[0].minRange,E=a.xAxis[0].options.maxRange;if(!this.hasDragged||w(g)){if(!z(c)||!z(t))if(l)g=0,d=h(e.width,m.width);else return;this.left=h(e.left,a.plotLeft+f+(r?a.plotWidth:0));this.size=v=C=h(e.len,(r?a.plotHeight:a.plotWidth)-2*f);a=r?f:C+2*f;g=h(g,e.toPixels(c,!0));d=h(d,e.toPixels(t,!0));z(g)&&Infinity!==Math.abs(g)||(g=0,d=a);c=e.toValue(g,!0);
t=e.toValue(d,!0);var q=Math.abs(b.correctFloat(t-c));q<x?this.grabbedLeft?g=e.toPixels(t-x,!0):this.grabbedRight&&(d=e.toPixels(c+x,!0)):w(E)&&q>E&&(this.grabbedLeft?g=e.toPixels(t-E,!0):this.grabbedRight&&(d=e.toPixels(c+E,!0)));this.zoomedMax=Math.min(Math.max(g,d,0),v);this.zoomedMin=Math.min(Math.max(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(g,d),0),v);this.range=this.zoomedMax-this.zoomedMin;v=Math.round(this.zoomedMax);g=Math.round(this.zoomedMin);u&&(this.navigatorGroup.attr({visibility:"visible"}),
l=l&&!this.hasDragged?"animate":"attr",this.drawMasks(g,v,r,l),this.drawOutline(g,v,r,l),this.navigatorOptions.handles.enabled&&(this.drawHandle(g,0,r,l),this.drawHandle(v,1,r,l)));this.scrollbar&&(r?(r=this.top-f,m=this.left-f+(u||!m.opposite?0:(m.titleOffset||0)+m.axisTitleMargin),f=C+2*f):(r=this.top+(u?this.height:-f),m=this.left-f),this.scrollbar.position(m,r,a,f),this.scrollbar.setRange(this.zoomedMin/(C||1),this.zoomedMax/(C||1)));this.rendered=!0}},addMouseEvents:function(){var c=this,d=c.chart,
g=d.container,a=[],f,e;c.mouseMoveHandler=f=function(g){c.onMouseMove(g)};c.mouseUpHandler=e=function(g){c.onMouseUp(g)};a=c.getPartsEvents("mousedown");a.push(k(g,"mousemove",f),k(g.ownerDocument,"mouseup",e));l&&(a.push(k(g,"touchmove",f),k(g.ownerDocument,"touchend",e)),a.concat(c.getPartsEvents("touchstart")));c.eventsToUnbind=a;c.series&&c.series[0]&&a.push(k(c.series[0].xAxis,"foundExtremes",function(){d.navigator.modifyNavigatorAxisExtremes()}))},getPartsEvents:function(c){var a=this,g=[];
["shades","handles"].forEach(function(d){a[d].forEach(function(t,f){g.push(k(t.element,c,function(c){a[d+"Mousedown"](c,f)}))})});return g},shadesMousedown:function(c,a){c=this.chart.pointer.normalize(c);var g=this.chart,d=this.xAxis,t=this.zoomedMin,f=this.left,e=this.size,m=this.range,h=c.chartX;g.inverted&&(h=c.chartY,f=this.top);if(1===a)this.grabbedCenter=h,this.fixedWidth=m,this.dragOffset=h-t;else{c=h-f-m/2;if(0===a)c=Math.max(0,c);else if(2===a&&c+m>=e)if(c=e-m,this.reversedExtremes){c-=m;
var u=this.getUnionExtremes().dataMin}else var b=this.getUnionExtremes().dataMax;c!==t&&(this.fixedWidth=m,a=d.toFixedRange(c,c+m,u,b),w(a.min)&&g.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"}))}},handlesMousedown:function(c,a){this.chart.pointer.normalize(c);c=this.chart;var g=c.xAxis[0],d=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=d?g.min:g.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,
this.fixedExtreme=d?g.max:g.min);c.fixedRange=null},onMouseMove:function(c){var d=this,g=d.chart,f=d.left,F=d.navigatorSize,e=d.range,m=d.dragOffset,u=g.inverted;c.touches&&0===c.touches[0].pageX||(c=g.pointer.normalize(c),g=c.chartX,u&&(f=d.top,g=c.chartY),d.grabbedLeft?(d.hasDragged=!0,d.render(0,0,g-f,d.otherHandlePos)):d.grabbedRight?(d.hasDragged=!0,d.render(0,0,d.otherHandlePos,g-f)):d.grabbedCenter&&(d.hasDragged=!0,g<m?g=m:g>F+m-e&&(g=F+m-e),d.render(0,0,g-m,g-m+e)),d.hasDragged&&d.scrollbar&&
h(d.scrollbar.options.liveRedraw,b.svg&&!a&&!this.chart.isBoosting)&&(c.DOMType=c.type,setTimeout(function(){d.onMouseUp(c)},0)))},onMouseUp:function(c){var d=this.chart,g=this.xAxis,a=this.scrollbar,f=c.DOMEvent||c;if(this.hasDragged&&(!a||!a.hasDragged)||"scrollbar"===c.trigger){a=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var e=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var m=this.fixedExtreme;this.zoomedMax===this.size&&(m=this.reversedExtremes?a.dataMin:
a.dataMax);0===this.zoomedMin&&(e=this.reversedExtremes?a.dataMax:a.dataMin);g=g.toFixedRange(this.zoomedMin,this.zoomedMax,e,m);w(g.min)&&d.xAxis[0].setExtremes(Math.min(g.min,g.max),Math.max(g.min,g.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:f})}"mousemove"!==c.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null)},removeEvents:function(){this.eventsToUnbind&&
(this.eventsToUnbind.forEach(function(c){c()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()},removeBaseSeriesEvents:function(){var c=this.baseSeries||[];this.navigatorEnabled&&c[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&c.forEach(function(c){x(c,"updatedData",this.updatedDataHandler)},this),c[0].xAxis&&x(c[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},init:function(c){var a=c.options,g=a.navigator,e=g.enabled,F=a.scrollbar,m=F.enabled;a=e?g.height:0;var b=m?F.height:
0;this.handles=[];this.shades=[];this.chart=c;this.setBaseSeries();this.height=a;this.scrollbarHeight=b;this.scrollbarEnabled=m;this.navigatorEnabled=e;this.navigatorOptions=g;this.scrollbarOptions=F;this.outlineHeight=a+b;this.opposite=h(g.opposite,!e&&c.inverted);var v=this;e=v.baseSeries;F=c.xAxis.length;m=c.yAxis.length;var l=e&&e[0]&&e[0].xAxis||c.xAxis[0]||{options:{}};c.isDirtyBox=!0;v.navigatorEnabled?(v.xAxis=new A(c,f({breaks:l.options.breaks,ordinal:l.options.ordinal},g.xAxis,{id:"navigator-x-axis",
yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:F,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},c.inverted?{offsets:[b,0,-b,0],width:a}:{offsets:[0,-b,0,b],height:a})),v.yAxis=new A(c,f(g.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:m,isInternal:!0,zoomEnabled:!1},c.inverted?{width:a}:{height:a})),e||g.series.data?v.updateNavigatorSeries(!1):0===c.series.length&&(v.unbindRedraw=k(c,"beforeRedraw",function(){0<
c.series.length&&!v.series&&(v.setBaseSeries(),v.unbindRedraw())})),v.reversedExtremes=c.inverted&&!v.xAxis.reversed||!c.inverted&&v.xAxis.reversed,v.renderElements(),v.addMouseEvents()):v.xAxis={translate:function(g,a){var d=c.xAxis[0],t=d.getExtremes(),f=d.len-2*b,e=u("min",d.options.min,t.dataMin);d=u("max",d.options.max,t.dataMax)-e;return a?g*d/f+e:f*(g-e)/d},toPixels:function(c){return this.translate(c)},toValue:function(c){return this.translate(c,!0)},toFixedRange:A.prototype.toFixedRange,
fake:!0};c.options.scrollbar.enabled&&(c.scrollbar=v.scrollbar=new d(c.renderer,f(c.options.scrollbar,{margin:v.navigatorEnabled?0:10,vertical:c.inverted}),c),k(v.scrollbar,"changed",function(g){var d=v.size,a=d*this.to;d*=this.from;v.hasDragged=v.scrollbar.hasDragged;v.render(0,0,d,a);(c.options.scrollbar.liveRedraw||"mousemove"!==g.DOMType&&"touchmove"!==g.DOMType)&&setTimeout(function(){v.onMouseUp(g)})}));v.addBaseSeriesEvents();v.addChartEvents()},getUnionExtremes:function(c){var d=this.chart.xAxis[0],
g=this.xAxis,a=g.options,f=d.options,e;c&&null===d.dataMin||(e={dataMin:h(a&&a.min,u("min",f.min,d.dataMin,g.dataMin,g.min)),dataMax:h(a&&a.max,u("max",f.max,d.dataMax,g.dataMax,g.max))});return e},setBaseSeries:function(c,d){var g=this.chart,a=this.baseSeries=[];c=c||g.options&&g.options.navigator.baseSeries||(g.series.length?b.find(g.series,function(c){return!c.options.isInternal}).index:0);(g.series||[]).forEach(function(g,d){g.options.isInternal||!g.options.showInNavigator&&(d!==c&&g.options.id!==
c||!1===g.options.showInNavigator)||a.push(g)});this.xAxis&&!this.xAxis.fake&&this.updateNavigatorSeries(!0,d)},updateNavigatorSeries:function(c,d){var g=this,a=g.chart,t=g.baseSeries,e,m,h=g.navigatorOptions.series,u,v={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:!1,isInternal:!0,states:{inactive:{opacity:1}}},b=g.series=(g.series||[]).filter(function(c){var a=c.baseSeries;return 0>t.indexOf(a)?
(a&&(x(a,"updatedData",g.updatedDataHandler),delete a.navigatorSeries),c.chart&&c.destroy(),!1):!0});t&&t.length&&t.forEach(function(c){var F=c.navigatorSeries,C=q({color:c.color,visible:c.visible},D(h)?r.navigator.series:h);F&&!1===g.navigatorOptions.adaptToUpdatedData||(v.name="Navigator "+t.length,e=c.options||{},u=e.navigatorOptions||{},m=f(e,v,C,u),C=u.data||C.data,g.hasNavigatorData=g.hasNavigatorData||!!C,m.data=C||e.data&&e.data.slice(0),F&&F.options?F.update(m,d):(c.navigatorSeries=a.initSeries(m),
c.navigatorSeries.baseSeries=c,b.push(c.navigatorSeries)))});if(h.data&&(!t||!t.length)||D(h))g.hasNavigatorData=!1,h=y(h),h.forEach(function(c,d){v.name="Navigator "+(b.length+1);m=f(r.navigator.series,{color:a.series[d]&&!a.series[d].options.isInternal&&a.series[d].color||a.options.colors[d]||a.options.colors[0]},v,c);m.data=c.data;m.data&&(g.hasNavigatorData=!0,b.push(a.initSeries(m)))});c&&this.addBaseSeriesEvents()},addBaseSeriesEvents:function(){var c=this,a=c.baseSeries||[];a[0]&&a[0].xAxis&&
k(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes);a.forEach(function(g){k(g,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)});k(g,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)});!1!==this.navigatorOptions.adaptToUpdatedData&&g.xAxis&&k(g,"updatedData",this.updatedDataHandler);k(g,"remove",function(){this.navigatorSeries&&(B(c.series,this.navigatorSeries),w(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)})},
this)},getBaseSeriesMin:function(c){return this.baseSeries.reduce(function(c,g){return Math.min(c,g.xData?g.xData[0]:c)},c)},modifyNavigatorAxisExtremes:function(){var c=this.xAxis,a;c.getExtremes&&(!(a=this.getUnionExtremes(!0))||a.dataMin===c.min&&a.dataMax===c.max||(c.min=a.dataMin,c.max=a.dataMax))},modifyBaseAxisExtremes:function(){var c=this.chart.navigator,a=this.getExtremes(),g=a.dataMin,d=a.dataMax;a=a.max-a.min;var f=c.stickToMin,e=c.stickToMax,m=h(this.options.overscroll,0),u=c.series&&
c.series[0],v=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(f){var b=g;var l=b+a}e&&(l=d+m,f||(b=Math.max(l-a,c.getBaseSeriesMin(u&&u.xData?u.xData[0]:-Number.MAX_VALUE))));v&&(f||e)&&z(b)&&(this.min=this.userMin=b,this.max=this.userMax=l)}c.stickToMin=c.stickToMax=null},updatedDataHandler:function(){var c=this.chart.navigator,a=this.navigatorSeries,g=c.getBaseSeriesMin(this.xData[0]);c.stickToMax=c.reversedExtremes?0===Math.round(c.zoomedMin):Math.round(c.zoomedMax)>=
Math.round(c.size);c.stickToMin=z(this.xAxis.min)&&this.xAxis.min<=g&&(!this.chart.fixedRange||!c.stickToMax);a&&!c.hasNavigatorData&&(a.options.pointStart=this.xData[0],a.setData(this.options.data,!1,null,!1))},addChartEvents:function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(k(this.chart,"redraw",function(){var c=this.navigator,a=c&&(c.baseSeries&&c.baseSeries[0]&&c.baseSeries[0].xAxis||c.scrollbar&&this.xAxis[0]);a&&c.render(a.min,a.max)}),k(this.chart,"getMargins",
function(){var c=this.navigator,a=c.opposite?"plotTop":"marginBottom";this.inverted&&(a=c.opposite?"marginRight":"plotLeft");this[a]=(this[a]||0)+(c.navigatorEnabled||!this.inverted?c.outlineHeight:0)+c.navigatorOptions.margin}))},destroy:function(){this.removeEvents();this.xAxis&&(B(this.chart.xAxis,this.xAxis),B(this.chart.axes,this.xAxis));this.yAxis&&(B(this.chart.yAxis,this.yAxis),B(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(c){c.destroy&&c.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(c){this[c]&&
this[c].destroy&&this[c].destroy();this[c]=null},this);[this.handles].forEach(function(c){E(c)},this)}};b.Navigator||(b.Navigator=p,k(A,"zoom",function(c){var d=this.chart.options,g=d.chart.zoomType,f=d.chart.pinchType,e=d.navigator;d=d.rangeSelector;this.isXAxis&&(e&&e.enabled||d&&d.enabled)&&("y"===g?c.zoomed=!1:(!a&&"xy"===g||a&&"xy"===f)&&this.options.range&&(g=this.previousZoom,w(c.newMin)?this.previousZoom=[this.min,this.max]:g&&(c.newMin=g[0],c.newMax=g[1],delete this.previousZoom)));void 0!==
c.zoomed&&c.preventDefault()}),k(n,"beforeShowResetZoom",function(){var c=this.options,d=c.navigator,g=c.rangeSelector;if((d&&d.enabled||g&&g.enabled)&&(!a&&"x"===c.chart.zoomType||a&&"x"===c.chart.pinchType))return!1}),k(n,"beforeRender",function(){var c=this.options;if(c.navigator.enabled||c.scrollbar.enabled)this.scroller=this.navigator=new p(this)}),k(n,"afterSetChartSize",function(){var c=this.legend,a=this.navigator;if(a){var g=c&&c.options;var d=a.xAxis;var f=a.yAxis;var e=a.scrollbarHeight;
this.inverted?(a.left=a.opposite?this.chartWidth-e-a.height:this.spacing[3]+e,a.top=this.plotTop+e):(a.left=this.plotLeft+e,a.top=a.navigatorOptions.top||this.chartHeight-a.height-e-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(g&&"bottom"===g.verticalAlign&&g.enabled&&!g.floating?c.legendHeight+h(g.margin,10):0));d&&f&&(this.inverted?d.options.left=f.options.left=a.left:d.options.top=f.options.top=a.top,d.setAxisSize(),f.setAxisSize())}}),k(n,"update",
function(c){var a=c.options.navigator||{},g=c.options.scrollbar||{};this.navigator||this.scroller||!a.enabled&&!g.enabled||(f(!0,this.options.navigator,a),f(!0,this.options.scrollbar,g),delete c.options.navigator,delete c.options.scrollbar)}),k(n,"afterUpdate",function(c){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new p(this),h(c.redraw,!0)&&this.redraw(c.animation))}),k(n,"afterAddSeries",function(){this.navigator&&
this.navigator.setBaseSeries(null,!1)}),k(m,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),n.prototype.callbacks.push(function(c){var a=c.navigator;a&&c.xAxis[0]&&(c=c.xAxis[0].getExtremes(),a.render(c.min,c.max))}))});G(p,"parts/OrdinalAxis.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(b,n){var p=n.defined;n=b.addEvent;var w=b.Axis,B=b.Chart,D=b.css,z=b.extend,y=b.noop,k=b.pick,A=b.timeUnits;n(b.Series,"updatedData",
function(){var e=this.xAxis;e&&e.options.ordinal&&delete e.ordinalIndex});w.prototype.getTimeTicks=function(e,b,E,q,l,a,f){var h=0,r,d,m={},u=[],v=-Number.MAX_VALUE,c=this.options.tickPixelInterval,t=this.chart.time,g=[];if(!this.options.ordinal&&!this.options.breaks||!l||3>l.length||void 0===b)return t.getTimeTicks.apply(t,arguments);var C=l.length;for(r=0;r<C;r++){var F=r&&l[r-1]>E;l[r]<b&&(h=r);if(r===C-1||l[r+1]-l[r]>5*a||F){if(l[r]>v){for(d=t.getTimeTicks(e,l[h],l[r],q);d.length&&d[0]<=v;)d.shift();
d.length&&(v=d[d.length-1]);g.push(u.length);u=u.concat(d)}h=r+1}if(F)break}d=d.info;if(f&&d.unitRange<=A.hour){r=u.length-1;for(h=1;h<r;h++)if(t.dateFormat("%d",u[h])!==t.dateFormat("%d",u[h-1])){m[u[h]]="day";var K=!0}K&&(m[u[0]]="day");d.higherRanks=m}d.segmentStarts=g;u.info=d;if(f&&p(c)){h=g=u.length;K=[];var k;for(t=[];h--;)r=this.translate(u[h]),k&&(t[h]=k-r),K[h]=k=r;t.sort();t=t[Math.floor(t.length/2)];t<.6*c&&(t=null);h=u[g-1]>E?g-1:g;for(k=void 0;h--;)r=K[h],g=Math.abs(k-r),k&&g<.8*c&&
(null===t||g<.8*t)?(m[u[h]]&&!m[u[h+1]]?(g=h+1,k=r):g=h,u.splice(g,1)):k=r}return u};z(w.prototype,{beforeSetTickPositions:function(){var e=[],b,E=!1,q=this.getExtremes(),l=q.min,a=q.max,f,h=this.isXAxis&&!!this.options.breaks;q=this.options.ordinal;var x=Number.MAX_VALUE,d=this.chart.options.chart.ignoreHiddenSeries,m;if(q||h){this.series.forEach(function(c,a){b=[];if(!(d&&!1===c.visible||!1===c.takeOrdinalPosition&&!h)&&(e=e.concat(c.processedXData),u=e.length,e.sort(function(a,c){return a-c}),
x=Math.min(x,k(c.closestPointRange,x)),u)){for(a=0;a<u-1;)e[a]!==e[a+1]&&b.push(e[a+1]),a++;b[0]!==e[0]&&b.unshift(e[0]);e=b}c.isSeriesBoosting&&(m=!0)});m&&(e.length=0);var u=e.length;if(2<u){var v=e[1]-e[0];for(f=u-1;f--&&!E;)e[f+1]-e[f]!==v&&(E=!0);!this.options.keepOrdinalPadding&&(e[0]-l>v||a-e[e.length-1]>v)&&(E=!0)}else this.options.overscroll&&(2===u?x=e[1]-e[0]:1===u?(x=this.options.overscroll,e=[e[0],e[0]+x]):x=this.overscrollPointsRange);E?(this.options.overscroll&&(this.overscrollPointsRange=
x,e=e.concat(this.getOverscrollPositions())),this.ordinalPositions=e,v=this.ordinal2lin(Math.max(l,e[0]),!0),f=Math.max(this.ordinal2lin(Math.min(a,e[e.length-1]),!0),1),this.ordinalSlope=a=(a-l)/(f-v),this.ordinalOffset=l-v*a):(this.overscrollPointsRange=k(this.closestPointRange,this.overscrollPointsRange),this.ordinalPositions=this.ordinalSlope=this.ordinalOffset=void 0)}this.isOrdinal=q&&E;this.groupIntervalFactor=null},val2lin:function(e,b){var r=this.ordinalPositions;if(r){var q=r.length,l;for(l=
q;l--;)if(r[l]===e){var a=l;break}for(l=q-1;l--;)if(e>r[l]||0===l){e=(e-r[l])/(r[l+1]-r[l]);a=l+e;break}b=b?a:this.ordinalSlope*(a||0)+this.ordinalOffset}else b=e;return b},lin2val:function(e,b){var r=this.ordinalPositions;if(r){var q=this.ordinalSlope,l=this.ordinalOffset,a=r.length-1;if(b)if(0>e)e=r[0];else if(e>a)e=r[a];else{a=Math.floor(e);var f=e-a}else for(;a--;)if(b=q*a+l,e>=b){q=q*(a+1)+l;f=(e-b)/(q-b);break}return void 0!==f&&void 0!==r[a]?r[a]+(f?f*(r[a+1]-r[a]):0):e}return e},getExtendedPositions:function(){var e=
this,b=e.chart,k=e.series[0].currentDataGrouping,q=e.ordinalIndex,l=k?k.count+k.unitName:"raw",a=e.options.overscroll,f=e.getExtremes(),h;q||(q=e.ordinalIndex={});if(!q[l]){var x={series:[],chart:b,getExtremes:function(){return{min:f.dataMin,max:f.dataMax+a}},options:{ordinal:!0},val2lin:w.prototype.val2lin,ordinal2lin:w.prototype.ordinal2lin};e.series.forEach(function(a){h={xAxis:x,xData:a.xData.slice(),chart:b,destroyGroupedData:y};h.xData=h.xData.concat(e.getOverscrollPositions());h.options={dataGrouping:k?
{enabled:!0,forced:!0,approximation:"open",units:[[k.unitName,[k.count]]]}:{enabled:!1}};a.processData.apply(h);x.series.push(h)});e.beforeSetTickPositions.apply(x);q[l]=x.ordinalPositions}return q[l]},getOverscrollPositions:function(){var e=this.options.overscroll,b=this.overscrollPointsRange,k=[],q=this.dataMax;if(p(b))for(k.push(q);q<=this.dataMax+e;)q+=b,k.push(q);return k},getGroupIntervalFactor:function(e,b,k){k=k.processedXData;var r=k.length,l=[];var a=this.groupIntervalFactor;if(!a){for(a=
0;a<r-1;a++)l[a]=k[a+1]-k[a];l.sort(function(a,e){return a-e});l=l[Math.floor(r/2)];e=Math.max(e,k[0]);b=Math.min(b,k[r-1]);this.groupIntervalFactor=a=r*l/(b-e)}return a},postProcessTickInterval:function(e){var b=this.ordinalSlope;return b?this.options.breaks?this.closestPointRange||e:e/(b/this.closestPointRange):e}});w.prototype.ordinal2lin=w.prototype.val2lin;n(B,"pan",function(e){var b=this.xAxis[0],k=b.options.overscroll,q=e.originalEvent.chartX,l=!1;if(b.options.ordinal&&b.series.length){var a=
this.mouseDownX,f=b.getExtremes(),h=f.dataMax,x=f.min,d=f.max,m=this.hoverPoints,u=b.closestPointRange||b.overscrollPointsRange;a=(a-q)/(b.translationSlope*(b.ordinalSlope||u));var v={ordinalPositions:b.getExtendedPositions()};u=b.lin2val;var c=b.val2lin;if(!v.ordinalPositions)l=!0;else if(1<Math.abs(a)){m&&m.forEach(function(a){a.setState()});if(0>a){m=v;var t=b.ordinalPositions?b:v}else m=b.ordinalPositions?b:v,t=v;v=t.ordinalPositions;h>v[v.length-1]&&v.push(h);this.fixedRange=d-x;a=b.toFixedRange(null,
null,u.apply(m,[c.apply(m,[x,!0])+a,!0]),u.apply(t,[c.apply(t,[d,!0])+a,!0]));a.min>=Math.min(f.dataMin,x)&&a.max<=Math.max(h,d)+k&&b.setExtremes(a.min,a.max,!0,!1,{trigger:"pan"});this.mouseDownX=q;D(this.container,{cursor:"move"})}}else l=!0;l?k&&(b.max=b.dataMax+k):e.preventDefault()});n(w,"foundExtremes",function(){this.isXAxis&&p(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&
(this.max+=this.options.overscroll,!this.isInternal&&p(this.userMin)&&(this.min+=this.options.overscroll))});n(w,"afterSetScale",function(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)})});G(p,"modules/broken-axis.src.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(b,n){var p=n.isArray;n=b.addEvent;var w=b.pick,B=b.extend,D=b.find,z=b.fireEvent,y=b.Axis,k=b.Series,A=function(e,b){return D(b,function(b){return b.from<
e&&e<b.to})};B(y.prototype,{isInBreak:function(e,b){var k=e.repeat||Infinity,r=e.from,l=e.to-e.from;b=b>=r?(b-r)%k:k-(r-b)%k;return e.inclusive?b<=l:b<l&&0!==b},isInAnyBreak:function(e,b){var k=this.options.breaks,r=k&&k.length,l;if(r){for(;r--;)if(this.isInBreak(k[r],e)){var a=!0;l||(l=w(k[r].showPoints,!this.isXAxis))}var f=a&&b?a&&!l:a}return f}});n(y,"afterInit",function(){"function"===typeof this.setBreaks&&this.setBreaks(this.options.breaks,!1)});n(y,"afterSetTickPositions",function(){if(this.isBroken){var e=
this.tickPositions,b=this.tickPositions.info,k=[],q;for(q=0;q<e.length;q++)this.isInAnyBreak(e[q])||k.push(e[q]);this.tickPositions=k;this.tickPositions.info=b}});n(y,"afterSetOptions",function(){this.isBroken&&(this.options.ordinal=!1)});y.prototype.setBreaks=function(e,b){function k(a){var f=a,e;for(e=0;e<l.breakArray.length;e++){var d=l.breakArray[e];if(d.to<=a)f-=d.len;else if(d.from>=a)break;else if(l.isInBreak(d,a)){f-=a-d.from;break}}return f}function r(a){var f;for(f=0;f<l.breakArray.length;f++){var e=
l.breakArray[f];if(e.from>=a)break;else e.to<a?a+=e.len:l.isInBreak(e,a)&&(a+=e.len)}return a}var l=this,a=p(e)&&!!e.length;l.isDirty=l.isBroken!==a;l.isBroken=a;l.options.breaks=l.userOptions.breaks=e;l.forceRedraw=!0;a||l.val2lin!==k||(delete l.val2lin,delete l.lin2val);a&&(l.userOptions.ordinal=!1,l.val2lin=k,l.lin2val=r,l.setExtremes=function(a,e,b,d,m){if(this.isBroken){for(var f,h=this.options.breaks;f=A(a,h);)a=f.to;for(;f=A(e,h);)e=f.from;e<a&&(e=a)}y.prototype.setExtremes.call(this,a,e,b,
d,m)},l.setAxisTranslation=function(a){y.prototype.setAxisTranslation.call(this,a);this.unitLength=null;if(this.isBroken){a=l.options.breaks;var e=[],f=[],d=0,b,u=l.userMin||l.min,v=l.userMax||l.max,c=w(l.pointRangePadding,0),t;a.forEach(function(a){b=a.repeat||Infinity;l.isInBreak(a,u)&&(u+=a.to%b-u%b);l.isInBreak(a,v)&&(v-=v%b-a.from%b)});a.forEach(function(a){C=a.from;for(b=a.repeat||Infinity;C-b>u;)C-=b;for(;C<u;)C+=b;for(t=C;t<v;t+=b)e.push({value:t,move:"in"}),e.push({value:t+(a.to-a.from),
move:"out",size:a.breakSize})});e.sort(function(a,c){return a.value===c.value?("in"===a.move?0:1)-("in"===c.move?0:1):a.value-c.value});var g=0;var C=u;e.forEach(function(a){g+="in"===a.move?1:-1;1===g&&"in"===a.move&&(C=a.value);0===g&&(f.push({from:C,to:a.value,len:a.value-C-(a.size||0)}),d+=a.value-C-(a.size||0))});l.breakArray=f;l.unitLength=v-u-d+c;z(l,"afterBreaks");l.staticScale?l.transA=l.staticScale:l.unitLength&&(l.transA*=(v-l.min+c)/l.unitLength);c&&(l.minPixelPadding=l.transA*l.minPointOffset);
l.min=u;l.max=v}});w(b,!0)&&this.chart.redraw()};n(k,"afterGeneratePoints",function(){var e=this.xAxis,b=this.yAxis,k=this.points,q=k.length,l=this.options.connectNulls;if(e&&b&&(e.options.breaks||b.options.breaks))for(;q--;){var a=k[q];var f=null===a.y&&!1===l;f||!e.isInAnyBreak(a.x,!0)&&!b.isInAnyBreak(a.y,!0)||(k.splice(q,1),this.data[q]&&this.data[q].destroyElements())}});n(k,"afterRender",function(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,w(this.pointArrayMap,["y"]))});b.Series.prototype.drawBreaks=
function(e,b){var k=this,r=k.points,l,a,f,h;e&&b.forEach(function(b){l=e.breakArray||[];a=e.isXAxis?e.min:w(k.options.threshold,e.min);r.forEach(function(d){h=w(d["stack"+b.toUpperCase()],d[b]);l.forEach(function(b){f=!1;if(a<b.from&&h>b.to||a>b.from&&h<b.from)f="pointBreak";else if(a<b.from&&h>b.from&&h<b.to||a>b.from&&h>b.to&&h<b.from)f="pointInBreak";f&&z(e,f,{point:d,brk:b})})})})};b.Series.prototype.gappedPath=function(){var e=this.currentDataGrouping,k=e&&e.gapSize;e=this.options.gapSize;var n=
this.points.slice(),q=n.length-1,l=this.yAxis;if(e&&0<q)for("value"!==this.options.gapUnit&&(e*=this.basePointRange),k&&k>e&&k>=this.basePointRange&&(e=k);q--;)n[q+1].x-n[q].x>e&&(k=(n[q].x+n[q+1].x)/2,n.splice(q+1,0,{isNull:!0,x:k}),this.options.stacking&&(k=l.stacks[this.stackKey][k]=new b.StackItem(l,l.options.stackLabels,!1,k,this.stack),k.total=0));return this.getGraphPath(n)}});G(p,"masters/modules/broken-axis.src.js",[],function(){});G(p,"parts/DataGrouping.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],
function(b,n){var p=n.defined,w=n.isNumber;n=b.addEvent;var B=b.arrayMax,D=b.arrayMin,z=b.Axis,y=b.correctFloat,k=b.defaultPlotOptions,A=b.extend,e=b.format,r=b.merge,E=b.pick,q=b.Point,l=b.Series,a=b.Tooltip,f=b.approximations={sum:function(a){var c=a.length;if(!c&&a.hasNulls)var g=null;else if(c)for(g=0;c--;)g+=a[c];return g},average:function(a){var c=a.length;a=f.sum(a);w(a)&&c&&(a=y(a/c));return a},averages:function(){var a=[];[].forEach.call(arguments,function(c){a.push(f.average(c))});return void 0===
a[0]?void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},high:function(a){return a.length?B(a):a.hasNulls?null:void 0},low:function(a){return a.length?D(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},ohlc:function(a,c,d,b){a=f.open(a);c=f.high(c);d=f.low(d);b=f.close(b);if(w(a)||w(c)||w(d)||w(b))return[a,c,d,b]},range:function(a,c){a=f.low(a);c=f.high(c);if(w(a)||w(c))return[a,c];if(null===a&&null===c)return null}},h=function(a,
c,d,b){var g=this,e=g.data,m=g.options&&g.options.data,t=[],u=[],h=[],v=a.length,k=!!c,F=[],l=g.pointArrayMap,C=l&&l.length,K=["x"].concat(l||["y"]),q=0,n=0,x;b="function"===typeof b?b:f[b]?f[b]:f[g.getDGApproximation&&g.getDGApproximation()||"average"];C?l.forEach(function(){F.push([])}):F.push([]);var z=C||1;for(x=0;x<=v&&!(a[x]>=d[0]);x++);for(x;x<=v;x++){for(;void 0!==d[q+1]&&a[x]>=d[q+1]||x===v;){var y=d[q];g.dataGroupInfo={start:g.cropStart+n,length:F[0].length};var D=b.apply(g,F);g.pointClass&&
!p(g.dataGroupInfo.options)&&(g.dataGroupInfo.options=r(g.pointClass.prototype.optionsToObject.call({series:g},g.options.data[g.cropStart+n])),K.forEach(function(a){delete g.dataGroupInfo.options[a]}));void 0!==D&&(t.push(y),u.push(D),h.push(g.dataGroupInfo));n=x;for(y=0;y<z;y++)F[y].length=0,F[y].hasNulls=!1;q+=1;if(x===v)break}if(x===v)break;if(l)for(y=g.cropStart+x,D=e&&e[y]||g.pointClass.prototype.applyOptions.apply({series:g},[m[y]]),y=0;y<C;y++){var B=D[l[y]];w(B)?F[y].push(B):null===B&&(F[y].hasNulls=
!0)}else y=k?c[x]:null,w(y)?F[0].push(y):null===y&&(F[0].hasNulls=!0)}return{groupedXData:t,groupedYData:u,groupMap:h}},x={approximations:f,groupData:h},d=l.prototype,m=d.processData,u=d.generatePoints,v={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y",
"%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},c={line:{},spline:{},area:{},areaspline:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},t=b.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",
[1,3,6]],["year",null]];d.getDGApproximation=function(){return b.seriesTypes.arearange&&this instanceof b.seriesTypes.arearange?"range":b.seriesTypes.ohlc&&this instanceof b.seriesTypes.ohlc?"ohlc":b.seriesTypes.column&&this instanceof b.seriesTypes.column?"sum":"average"};d.groupData=h;d.processData=function(){var a=this.chart,c=this.options.dataGrouping,b=!1!==this.allowDG&&c&&E(c.enabled,a.options.isStock),e=this.visible||!a.options.chart.ignoreHiddenSeries,f,u=this.currentDataGrouping,h=!1;this.forceCrop=
b;this.groupPixelWidth=null;this.hasProcessed=!0;b&&!this.requireSorting&&(this.requireSorting=h=!0);b=!1===m.apply(this,arguments)||!b;h&&(this.requireSorting=!1);if(!b){this.destroyGroupedData();b=c.groupAll?this.xData:this.processedXData;var v=c.groupAll?this.yData:this.processedYData,k=a.plotSizeX;a=this.xAxis;var l=a.options.ordinal,r=this.groupPixelWidth=a.getGroupPixelWidth&&a.getGroupPixelWidth();if(r){this.isDirty=f=!0;this.points=null;h=a.getExtremes();var q=h.min;h=h.max;l=l&&a.getGroupIntervalFactor(q,
h,this)||1;r=r*(h-q)/k*l;k=a.getTimeTicks(a.normalizeTimeTickInterval(r,c.units||t),Math.min(q,b[0]),Math.max(h,b[b.length-1]),a.options.startOfWeek,b,this.closestPointRange);v=d.groupData.apply(this,[b,v,k,c.approximation]);b=v.groupedXData;l=v.groupedYData;var x=0;if(c.smoothed&&b.length){var n=b.length-1;for(b[n]=Math.min(b[n],h);n--&&0<n;)b[n]+=r/2;b[0]=Math.max(b[0],q)}for(n=1;n<k.length;n++)k.info.segmentStarts&&-1!==k.info.segmentStarts.indexOf(n)||(x=Math.max(k[n]-k[n-1],x));q=k.info;q.gapSize=
x;this.closestPointRange=k.info.totalRange;this.groupMap=v.groupMap;if(p(b[0])&&b[0]<a.min&&e){if(!p(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=b[0];a.dataMin=b[0]}c.groupAll&&(c=this.cropData(b,l,a.min,a.max,1),b=c.xData,l=c.yData);this.processedXData=b;this.processedYData=l}else this.groupMap=null;this.hasGroupedData=f;this.currentDataGrouping=q;this.preventGraphAnimation=(u&&u.totalRange)!==(q&&q.totalRange)}};d.destroyGroupedData=function(){var a=this.groupedData;(a||[]).forEach(function(c,
d){c&&(a[d]=c.destroy?c.destroy():null)});this.groupedData=null};d.generatePoints=function(){u.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};n(q,"update",function(){if(this.dataGroup)return b.error(24,!1,this.series.chart),!1});n(a,"headerFormatter",function(a){var c=this.chart.time,d=a.labelConfig,g=d.series,b=g.tooltipOptions,f=g.options.dataGrouping,m=b.xDateFormat,h=g.xAxis,u=b[(a.isFooter?"footer":"header")+"Format"];if(h&&"datetime"===h.options.type&&
f&&w(d.key)){var t=g.currentDataGrouping;f=f.dateTimeLabelFormats||v.dateTimeLabelFormats;if(t)if(b=f[t.unitName],1===t.count)m=b[0];else{m=b[1];var k=b[2]}else!m&&f&&(m=this.getXDateFormat(d,b,h));m=c.dateFormat(m,d.key);k&&(m+=c.dateFormat(k,d.key+t.totalRange-1));g.chart.styledMode&&(u=this.styledModeFormat(u));a.text=e(u,{point:A(d.point,{key:m}),series:g},c);a.preventDefault()}});n(l,"destroy",d.destroyGroupedData);n(l,"afterSetOptions",function(a){a=a.options;var d=this.type,g=this.chart.options.plotOptions,
b=k[d].dataGrouping,e=this.useCommonDataGrouping&&v;if(c[d]||e)b||(b=r(v,c[d])),a.dataGrouping=r(e,b,g.series&&g.series.dataGrouping,g[d].dataGrouping,this.userOptions.dataGrouping)});n(z,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=!1})});z.prototype.getGroupPixelWidth=function(){var a=this.series,c=a.length,d,b=0,e=!1,f;for(d=c;d--;)(f=a[d].options.dataGrouping)&&(b=Math.max(b,E(f.groupPixelWidth,v.groupPixelWidth)));for(d=c;d--;)(f=a[d].options.dataGrouping)&&a[d].hasProcessed&&
(c=(a[d].processedXData||a[d].data).length,a[d].groupPixelWidth||c>this.chart.plotSizeX/b||c&&f.forced)&&(e=!0);return e?b:0};z.prototype.setDataGrouping=function(a,c){var d;c=E(c,!0);a||(a={forced:!1,units:null});if(this instanceof z)for(d=this.series.length;d--;)this.series[d].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(c){c.dataGrouping=a},!1);this.ordinalSlope=null;c&&this.chart.redraw()};b.dataGrouping=x;"";return x});G(p,"parts/OHLCSeries.js",[p["parts/Globals.js"]],
function(b){var n=b.Point,p=b.seriesType,w=b.seriesTypes;p("ohlc","column",{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0},{directTouch:!1,pointArrayMap:["open","high","low","close"],toYData:function(b){return[b.open,b.high,b.low,b.close]},pointValKey:"close",pointAttrToOptions:{stroke:"color",
"stroke-width":"lineWidth"},init:function(){w.column.prototype.init.apply(this,arguments);this.options.stacking=!1},pointAttribs:function(b,n){n=w.column.prototype.pointAttribs.call(this,b,n);var p=this.options;delete n.fill;!b.options.color&&p.upColor&&b.open<b.close&&(n.stroke=p.upColor);return n},translate:function(){var b=this,n=b.yAxis,p=!!b.modifyValue,y=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];w.column.prototype.translate.apply(b);b.points.forEach(function(k){[k.open,k.high,
k.low,k.close,k.low].forEach(function(z,e){null!==z&&(p&&(z=b.modifyValue(z)),k[y[e]]=n.toPixels(z,!0))});k.tooltipPos[1]=k.plotHigh+n.pos-b.chart.plotTop})},drawPoints:function(){var b=this,n=b.chart;b.points.forEach(function(p){var y=p.graphic,k=!y;if(void 0!==p.plotY){y||(p.graphic=y=n.renderer.path().add(b.group));n.styledMode||y.attr(b.pointAttribs(p,p.selected&&"select"));var w=y.strokeWidth()%2/2;var e=Math.round(p.plotX)-w;var r=Math.round(p.shapeArgs.width/2);var z=["M",e,Math.round(p.yBottom),
"L",e,Math.round(p.plotHigh)];if(null!==p.open){var q=Math.round(p.plotOpen)+w;z.push("M",e,q,"L",e-r,q)}null!==p.close&&(q=Math.round(p.plotClose)+w,z.push("M",e,q,"L",e+r,q));y[k?"attr":"animate"]({d:z}).addClass(p.getClassName(),!0)}})},animate:null},{getClassName:function(){return n.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}});""});G(p,"parts/CandlestickSeries.js",[p["parts/Globals.js"]],function(b){var n=b.defaultPlotOptions,p=b.merge,
w=b.seriesType,B=b.seriesTypes;w("candlestick","ohlc",p(n.column,{states:{hover:{lineWidth:2}},tooltip:n.ohlc.tooltip,threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}),{pointAttribs:function(b,n){var p=B.column.prototype.pointAttribs.call(this,b,n),k=this.options,w=b.open<b.close,e=k.lineColor||this.color;p["stroke-width"]=k.lineWidth;p.fill=b.options.color||(w?k.upColor||this.color:this.color);p.stroke=b.options.lineColor||(w?k.upLineColor||e:e);n&&(b=k.states[n],
p.fill=b.color||p.fill,p.stroke=b.lineColor||p.stroke,p["stroke-width"]=b.lineWidth||p["stroke-width"]);return p},drawPoints:function(){var b=this,n=b.chart,p=b.yAxis.reversed;b.points.forEach(function(k){var y=k.graphic,e=!y;if(void 0!==k.plotY){y||(k.graphic=y=n.renderer.path().add(b.group));b.chart.styledMode||y.attr(b.pointAttribs(k,k.selected&&"select")).shadow(b.options.shadow);var r=y.strokeWidth()%2/2;var w=Math.round(k.plotX)-r;var q=k.plotOpen;var l=k.plotClose;var a=Math.min(q,l);q=Math.max(q,
l);var f=Math.round(k.shapeArgs.width/2);l=p?q!==k.yBottom:Math.round(a)!==Math.round(k.plotHigh);var h=p?Math.round(a)!==Math.round(k.plotHigh):q!==k.yBottom;a=Math.round(a)+r;q=Math.round(q)+r;r=[];r.push("M",w-f,q,"L",w-f,a,"L",w+f,a,"L",w+f,q,"Z","M",w,a,"L",w,l?Math.round(p?k.yBottom:k.plotHigh):a,"M",w,q,"L",w,h?Math.round(p?k.plotHigh:k.yBottom):q);y[e?"attr":"animate"]({d:r}).addClass(k.getClassName(),!0)}})}});""});G(p,"mixins/on-series.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],
function(b,n){var p=n.defined,w=b.seriesTypes,B=b.stableSort;return{getPlotBox:function(){return b.Series.prototype.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){w.column.prototype.translate.apply(this);var b=this,n=b.options,y=b.chart,k=b.points,A=k.length-1,e,r=n.onSeries;r=r&&y.get(r);n=n.onKey||"y";var E=r&&r.options.step,q=r&&r.points,l=q&&q.length,a=y.inverted,f=b.xAxis,h=b.yAxis,x=0,d;if(r&&r.visible&&l){x=(r.pointXOffset||0)+(r.barW||
0)/2;y=r.currentDataGrouping;var m=q[l-1].x+(y?y.totalRange:0);B(k,function(a,d){return a.x-d.x});for(n="plot"+n[0].toUpperCase()+n.substr(1);l--&&k[A];){var u=q[l];y=k[A];y.y=u.y;if(u.x<=y.x&&void 0!==u[n]){if(y.x<=m&&(y.plotY=u[n],u.x<y.x&&!E&&(d=q[l+1])&&void 0!==d[n])){var v=(y.x-u.x)/(d.x-u.x);y.plotY+=v*(d[n]-u[n]);y.y+=v*(d.y-u.y)}A--;l++;if(0>A)break}}}k.forEach(function(c,d){c.plotX+=x;if(void 0===c.plotY||a)0<=c.plotX&&c.plotX<=f.len?a?(c.plotY=f.translate(c.x,0,1,0,1),c.plotX=p(c.y)?h.translate(c.y,
0,0,0,1):0):c.plotY=(f.opposite?0:b.yAxis.len)+f.offset:c.shapeArgs={};if((e=k[d-1])&&e.plotX===c.plotX){void 0===e.stackIndex&&(e.stackIndex=0);var g=e.stackIndex+1}c.stackIndex=g});this.onSeries=r}}});G(p,"parts/FlagsSeries.js",[p["parts/Globals.js"],p["parts/Utilities.js"],p["mixins/on-series.js"]],function(b,n,p){function w(a){l[a+"pin"]=function(b,e,k,d,m){var f=m&&m.anchorX;m=m&&m.anchorY;"circle"===a&&d>k&&(b-=Math.round((d-k)/2),k=d);var h=l[a](b,e,k,d);f&&m&&(h.push("M","circle"===a?b+k/
2:h[1]+h[4]/2,e>m?e:e+d,"L",f,m),h=h.concat(l.circle(f-1,m-1,2,2)));return h}}var B=n.defined,D=n.isNumber,z=n.objectEach,y=b.addEvent,k=b.merge;n=b.noop;var A=b.Renderer,e=b.Series,r=b.seriesType,E=b.TrackerMixin,q=b.VMLRenderer,l=b.SVGRenderer.prototype.symbols;r("flags","column",{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}<br/>"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},
style:{fontSize:"11px",fontWeight:"bold"}},{sorted:!1,noSharedTooltip:!0,allowDG:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],forceCrop:!0,init:e.prototype.init,pointAttribs:function(a,b){var e=this.options,f=a&&a.color||this.color,d=e.lineColor,m=a&&a.lineWidth;a=a&&a.fillColor||e.fillColor;b&&(a=e.states[b].fillColor,d=e.states[b].lineColor,m=e.states[b].lineWidth);return{fill:a||f,stroke:d||f,"stroke-width":m||e.lineWidth||0}},translate:p.translate,getPlotBox:p.getPlotBox,drawPoints:function(){var a=
this.points,e=this.chart,h=e.renderer,l=e.inverted,d=this.options,m=d.y,u,v=this.yAxis,c={},t=[];for(u=a.length;u--;){var g=a[u];var n=(l?g.plotY:g.plotX)>this.xAxis.len;var r=g.plotX;var q=g.stackIndex;var p=g.options.shape||d.shape;var w=g.plotY;void 0!==w&&(w=g.plotY+m-(void 0!==q&&q*d.stackDistance));g.anchorX=q?void 0:g.plotX;var y=q?void 0:g.plotY;var N="flag"!==p;q=g.graphic;void 0!==w&&0<=r&&!n?(q||(q=g.graphic=h.label("",null,null,p,null,null,d.useHTML),e.styledMode||q.attr(this.pointAttribs(g)).css(k(d.style,
g.style)),q.attr({align:N?"center":"left",width:d.width,height:d.height,"text-align":d.textAlign}).addClass("highcharts-point").add(this.markerGroup),g.graphic.div&&(g.graphic.div.point=g),e.styledMode||q.shadow(d.shadow),q.isNew=!0),0<r&&(r-=q.strokeWidth()%2),p={y:w,anchorY:y},d.allowOverlapX&&(p.x=r,p.anchorX=g.anchorX),q.attr({text:g.options.title||d.title||"A"})[q.isNew?"attr":"animate"](p),d.allowOverlapX||(c[g.plotX]?c[g.plotX].size=Math.max(c[g.plotX].size,q.width):c[g.plotX]={align:N?.5:
0,size:q.width,target:r,anchorX:r}),g.tooltipPos=[r,w+v.pos-e.plotTop]):q&&(g.graphic=q.destroy())}d.allowOverlapX||(z(c,function(a){a.plotX=a.anchorX;t.push(a)}),b.distribute(t,l?v.len:this.xAxis.len,100),a.forEach(function(a){var d=a.graphic&&c[a.plotX];d&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:d.pos+d.align*d.size,anchorX:a.anchorX}),B(d.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));d.useHTML&&b.wrap(this.markerGroup,"on",function(a){return b.SVGElement.prototype.on.apply(a.apply(this,
[].slice.call(arguments,1)),[].slice.call(arguments,1))})},drawTracker:function(){var a=this.points;E.drawTrackerPoint.apply(this);a.forEach(function(b){var e=b.graphic;e&&y(e.element,"mouseover",function(){0<b.stackIndex&&!b.raised&&(b._y=e.y,e.attr({y:b._y-8}),b.raised=!0);a.forEach(function(a){a!==b&&a.raised&&a.graphic&&(a.graphic.attr({y:a._y}),a.raised=!1)})})})},animate:function(a){a?this.setClip():this.animate=null},setClip:function(){e.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&
this.sharedClipKey&&this.markerGroup.clip(this.chart[this.sharedClipKey])},buildKDTree:n,invertGroups:n},{isValid:function(){return D(this.y)||void 0===this.y}});l.flag=function(a,b,e,k,d){var f=d&&d.anchorX||a;d=d&&d.anchorY||b;return l.circle(f-1,d-1,2,2).concat(["M",f,d,"L",a,b+k,a,b,a+e,b,a+e,b+k,a,b+k,"Z"])};w("circle");w("square");A===q&&["circlepin","flag","squarepin"].forEach(function(a){q.prototype.symbols[a]=l[a]});""});G(p,"parts/RangeSelector.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],
function(b,n){function p(a){this.init(a)}var w=n.defined,B=n.isNumber,D=n.objectEach,z=n.pInt,y=n.splat,k=b.addEvent,A=b.Axis;n=b.Chart;var e=b.css,r=b.createElement,E=b.defaultOptions,q=b.destroyObjectProperties,l=b.discardElement,a=b.extend,f=b.fireEvent,h=b.merge,x=b.pick;a(E,{rangeSelector:{verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputPosition:{align:"right",x:0,y:0},buttonPosition:{align:"left",x:0,y:0},labelStyle:{color:"#666666"}}});
E.lang=h(E.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"From",rangeSelectorTo:"To"});p.prototype={clickButton:function(a,b){var d=this.chart,e=this.buttonOptions[a],c=d.xAxis[0],f=d.scroller&&d.scroller.getUnionExtremes()||c||{},g=f.dataMin,m=f.dataMax,h=c&&Math.round(Math.min(c.max,x(m,c.max))),l=e.type;f=e._range;var n,q=e.dataGrouping;if(null!==g&&null!==m){d.fixedRange=f;q&&(this.forcedDataGrouping=!0,A.prototype.setDataGrouping.call(c||{chart:this.chart},q,!1),this.frozenStates=e.preserveDataGrouping);
if("month"===l||"year"===l)if(c){l={range:e,max:h,chart:d,dataMin:g,dataMax:m};var r=c.minFromRange.call(l);B(l.newMax)&&(h=l.newMax)}else f=e;else if(f)r=Math.max(h-f,g),h=Math.min(r+f,m);else if("ytd"===l)if(c)void 0===m&&(g=Number.MAX_VALUE,m=Number.MIN_VALUE,d.series.forEach(function(a){a=a.xData;g=Math.min(a[0],g);m=Math.max(a[a.length-1],m)}),b=!1),h=this.getYTDExtremes(m,g,d.time.useUTC),r=n=h.min,h=h.max;else{this.deferredYTDClick=a;return}else"all"===l&&c&&(r=g,h=m);r+=e._offsetMin;h+=e._offsetMax;
this.setSelected(a);if(c)c.setExtremes(r,h,x(b,1),null,{trigger:"rangeSelectorButton",rangeSelectorButton:e});else{var p=y(d.options.xAxis)[0];var w=p.range;p.range=f;var U=p.min;p.min=n;k(d,"load",function(){p.range=w;p.min=U})}}},setSelected:function(a){this.selected=this.options.selected=a},defaultButtons:[{type:"month",count:1,text:"1m"},{type:"month",count:3,text:"3m"},{type:"month",count:6,text:"6m"},{type:"ytd",text:"YTD"},{type:"year",count:1,text:"1y"},{type:"all",text:"All"}],init:function(a){var d=
this,b=a.options.rangeSelector,e=b.buttons||[].concat(d.defaultButtons),c=b.selected,h=function(){var a=d.minInput,c=d.maxInput;a&&a.blur&&f(a,"blur");c&&c.blur&&f(c,"blur")};d.chart=a;d.options=b;d.buttons=[];d.buttonOptions=e;this.unMouseDown=k(a.container,"mousedown",h);this.unResize=k(a,"resize",h);e.forEach(d.computeButtonRange);void 0!==c&&e[c]&&this.clickButton(c,!1);k(a,"load",function(){a.xAxis&&a.xAxis[0]&&k(a.xAxis[0],"setExtremes",function(c){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==
c.trigger&&"updatedData"!==c.trigger&&d.forcedDataGrouping&&!d.frozenStates&&this.setDataGrouping(!1,!1)})})},updateButtonStates:function(){var a=this,b=this.chart,e=b.xAxis[0],f=Math.round(e.max-e.min),c=!e.hasVisibleSeries,h=b.scroller&&b.scroller.getUnionExtremes()||e,g=h.dataMin,k=h.dataMax;b=a.getYTDExtremes(k,g,b.time.useUTC);var l=b.min,n=b.max,r=a.selected,q=B(r),p=a.options.allButtonsEnabled,x=a.buttons;a.buttonOptions.forEach(function(d,b){var h=d._range,m=d.type,t=d.count||1,u=x[b],v=0,
F=d._offsetMax-d._offsetMin;d=b===r;var C=h>k-g,w=h<e.minRange,y=!1,N=!1;h=h===f;("month"===m||"year"===m)&&f+36E5>=864E5*{month:28,year:365}[m]*t-F&&f-36E5<=864E5*{month:31,year:366}[m]*t+F?h=!0:"ytd"===m?(h=n-l+F===f,y=!d):"all"===m&&(h=e.max-e.min>=k-g,N=!d&&q&&h);m=!p&&(C||w||N||c);t=d&&h||h&&!q&&!y||d&&a.frozenStates;m?v=3:t&&(q=!0,v=2);u.state!==v&&(u.setState(v),0===v&&r===b&&a.setSelected(null))})},computeButtonRange:function(a){var d=a.type,b=a.count||1,e={millisecond:1,second:1E3,minute:6E4,
hour:36E5,day:864E5,week:6048E5};if(e[d])a._range=e[d]*b;else if("month"===d||"year"===d)a._range=864E5*{month:30,year:365}[d]*b;a._offsetMin=x(a.offsetMin,0);a._offsetMax=x(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin},setInputValue:function(a,b){var d=this.chart.options.rangeSelector,e=this.chart.time,c=this[a+"Input"];w(b)&&(c.previousValue=c.HCTime,c.HCTime=b);c.value=e.dateFormat(d.inputEditDateFormat||"%Y-%m-%d",c.HCTime);this[a+"DateBox"].attr({text:e.dateFormat(d.inputDateFormat||"%b %e, %Y",
c.HCTime)})},showInput:function(a){var d=this.inputGroup,b=this[a+"DateBox"];e(this[a+"Input"],{left:d.translateX+b.x+"px",top:d.translateY+"px",width:b.width-2+"px",height:b.height-2+"px",border:"2px solid silver"})},hideInput:function(a){e(this[a+"Input"],{border:0,width:"1px",height:"1px"});this.setInputValue(a)},drawInput:function(d){function f(){var a=p.value,c=(g.inputDateParser||Date.parse)(a),d=l.xAxis[0],b=l.scroller&&l.scroller.xAxis?l.scroller.xAxis:d,e=b.dataMin;b=b.dataMax;c!==p.previousValue&&
(p.previousValue=c,B(c)||(c=a.split("-"),c=Date.UTC(z(c[0]),z(c[1])-1,z(c[2]))),B(c)&&(l.time.useUTC||(c+=6E4*(new Date).getTimezoneOffset()),q?c>k.maxInput.HCTime?c=void 0:c<e&&(c=e):c<k.minInput.HCTime?c=void 0:c>b&&(c=b),void 0!==c&&d.setExtremes(q?c:d.min,q?d.max:c,void 0,void 0,{trigger:"rangeSelectorInput"})))}var k=this,l=k.chart,c=l.renderer.style||{},t=l.renderer,g=l.options.rangeSelector,n=k.div,q="min"===d,p,x,w=this.inputGroup;this[d+"Label"]=x=t.label(E.lang[q?"rangeSelectorFrom":"rangeSelectorTo"],
this.inputGroup.offset).addClass("highcharts-range-label").attr({padding:2}).add(w);w.offset+=x.width+5;this[d+"DateBox"]=t=t.label("",w.offset).addClass("highcharts-range-input").attr({padding:2,width:g.inputBoxWidth||90,height:g.inputBoxHeight||17,"text-align":"center"}).on("click",function(){k.showInput(d);k[d+"Input"].focus()});l.styledMode||t.attr({stroke:g.inputBoxBorderColor||"#cccccc","stroke-width":1});t.add(w);w.offset+=t.width+(q?10:0);this[d+"Input"]=p=r("input",{name:d,className:"highcharts-range-selector",
type:"text"},{top:l.plotTop+"px"},n);l.styledMode||(x.css(h(c,g.labelStyle)),t.css(h({color:"#333333"},c,g.inputStyle)),e(p,a({position:"absolute",border:0,width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:c.fontSize,fontFamily:c.fontFamily,top:"-9999em"},g.inputStyle)));p.onfocus=function(){k.showInput(d)};p.onblur=function(){p===b.doc.activeElement&&f();k.hideInput(d);p.blur()};p.onchange=f;p.onkeypress=function(a){13===a.keyCode&&f()}},getPosition:function(){var a=this.chart,b=a.options.rangeSelector;
a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}},getYTDExtremes:function(a,b,e){var d=this.chart.time,c=new d.Date(a),f=d.get("FullYear",c);e=e?d.Date.UTC(f,0,1):+new d.Date(f,0,1);b=Math.max(b||0,e);c=c.getTime();return{max:Math.min(a||c,c),min:b}},render:function(a,b){var d=this,e=d.chart,c=e.renderer,f=e.container,g=e.options,h=g.exporting&&!1!==g.exporting.enabled&&g.navigation&&g.navigation.buttonOptions,k=E.lang,l=
d.div,m=g.rangeSelector,n=x(g.chart.style&&g.chart.style.zIndex,0)+1;g=m.floating;var q=d.buttons;l=d.inputGroup;var p=m.buttonTheme,w=m.buttonPosition,y=m.inputPosition,B=m.inputEnabled,z=p&&p.states,D=e.plotLeft,A=d.buttonGroup;var G=d.rendered;var L=d.options.verticalAlign,O=e.legend,P=O&&O.options,Q=w.y,M=y.y,R=G||!1,S=R?"animate":"attr",J=0,H=0,I;if(!1!==m.enabled){G||(d.group=G=c.g("range-selector-group").attr({zIndex:7}).add(),d.buttonGroup=A=c.g("range-selector-buttons").add(G),d.zoomText=
c.text(k.rangeSelectorZoom,0,15).add(A),e.styledMode||(d.zoomText.css(m.labelStyle),p["stroke-width"]=x(p["stroke-width"],0)),d.buttonOptions.forEach(function(a,b){q[b]=c.button(a.text,0,0,function(c){var e=a.events&&a.events.click,g;e&&(g=e.call(a,c));!1!==g&&d.clickButton(b);d.isActive=!0},p,z&&z.hover,z&&z.select,z&&z.disabled).attr({"text-align":"center"}).add(A)}),!1!==B&&(d.div=l=r("div",null,{position:"relative",height:0,zIndex:n}),f.parentNode.insertBefore(l,f),d.inputGroup=l=c.g("input-group").add(G),
l.offset=0,d.drawInput("min"),d.drawInput("max")));d.zoomText[S]({x:x(D+w.x,D)});var T=x(D+w.x,D)+d.zoomText.getBBox().width+5;d.buttonOptions.forEach(function(a,c){q[c][S]({x:T});T+=q[c].width+x(m.buttonSpacing,5)});D=e.plotLeft-e.spacing[3];d.updateButtonStates();h&&this.titleCollision(e)&&"top"===L&&"right"===w.align&&w.y+A.getBBox().height-12<(h.y||0)+h.height&&(J=-40);"left"===w.align?I=w.x-e.spacing[3]:"right"===w.align&&(I=w.x+J-e.spacing[1]);A.align({y:w.y,width:A.getBBox().width,align:w.align,
x:I},!0,e.spacingBox);d.group.placed=R;d.buttonGroup.placed=R;!1!==B&&(J=h&&this.titleCollision(e)&&"top"===L&&"right"===y.align&&y.y-l.getBBox().height-12<(h.y||0)+h.height+e.spacing[0]?-40:0,"left"===y.align?I=D:"right"===y.align&&(I=-Math.max(e.axisOffset[1],-J)),l.align({y:y.y,width:l.getBBox().width,align:y.align,x:y.x+I-2},!0,e.spacingBox),f=l.alignAttr.translateX+l.alignOptions.x-J+l.getBBox().x+2,h=l.alignOptions.width,k=A.alignAttr.translateX+A.getBBox().x,I=A.getBBox().width+20,(y.align===
w.align||k+I>f&&f+h>k&&Q<M+l.getBBox().height)&&l.attr({translateX:l.alignAttr.translateX+(e.axisOffset[1]>=-J?0:-J),translateY:l.alignAttr.translateY+A.getBBox().height+10}),d.setInputValue("min",a),d.setInputValue("max",b),d.inputGroup.placed=R);d.group.align({verticalAlign:L},!0,e.spacingBox);a=d.group.getBBox().height+20;b=d.group.alignAttr.translateY;"bottom"===L&&(O=P&&"bottom"===P.verticalAlign&&P.enabled&&!P.floating?O.legendHeight+x(P.margin,10):0,a=a+O-20,H=b-a-(g?0:m.y)-10);if("top"===
L)g&&(H=0),e.titleOffset&&e.titleOffset[0]&&(H=e.titleOffset[0]+e.options.title.margin),H+=e.margin[0]-e.spacing[0]||0;else if("middle"===L)if(M===Q)H=0>M?b+void 0:b;else if(M||Q)H=0>M||0>Q?H-Math.min(M,Q):b-a+NaN;d.group.translate(m.x,m.y+Math.floor(H));!1!==B&&(d.minInput.style.marginTop=d.group.translateY+"px",d.maxInput.style.marginTop=d.group.translateY+"px");d.rendered=!0}},getHeight:function(){var a=this.options,b=this.group,e=a.y,f=a.buttonPosition.y,c=a.inputPosition.y;if(a.height)return a.height;
a=b?b.getBBox(!0).height+13+e:0;b=Math.min(c,f);if(0>c&&0>f||0<c&&0<f)a+=Math.abs(b);return a},titleCollision:function(a){return!(a.options.title.text||a.options.subtitle.text)},update:function(a){var b=this.chart;h(!0,b.options.rangeSelector,a);this.destroy();this.init(b);b.rangeSelector.render()},destroy:function(){var a=this,b=a.minInput,e=a.maxInput;a.unMouseDown();a.unResize();q(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);e&&(e.onfocus=e.onblur=e.onchange=null);D(a,function(b,c){b&&"chart"!==
c&&(b.destroy?b.destroy():b.nodeType&&l(this[c]));b!==p.prototype[c]&&(a[c]=null)},this)}};A.prototype.minFromRange=function(){var a=this.range,b={month:"Month",year:"FullYear"}[a.type],e=this.max,f=this.chart.time,c=function(a,c){var d=new f.Date(a),e=f.get(b,d);f.set(b,d,e+c);e===f.get(b,d)&&f.set("Date",d,0);return d.getTime()-a};if(B(a)){var h=e-a;var g=a}else h=e+c(e,-a.count),this.chart&&(this.chart.fixedRange=e-h);var k=x(this.dataMin,Number.MIN_VALUE);B(h)||(h=k);h<=k&&(h=k,void 0===g&&(g=
c(h,a.count)),this.newMax=Math.min(h+g,this.dataMax));B(e)||(h=void 0);return h};b.RangeSelector||(k(n,"afterGetContainer",function(){this.options.rangeSelector.enabled&&(this.rangeSelector=new p(this))}),k(n,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(B(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===
a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}),k(n,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var d=this.extraBottomMargin,e=this.extraTopMargin;b&&b.enabled&&!w(a)&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=new p(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(a.render(),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=
!0)),this.extraBottomMargin!==d||this.extraTopMargin!==e)&&(this.isDirtyBox=!0)}),k(n,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}),k(n,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}),n.prototype.callbacks.push(function(a){function b(){d=a.xAxis[0].getExtremes();
B(d.min)&&e.render(d.min,d.max)}var d,e=a.rangeSelector;if(e){var c=k(a.xAxis[0],"afterSetExtremes",function(a){e.render(a.min,a.max)});var f=k(a,"redraw",b);b()}k(a,"destroy",function(){e&&(f(),c())})}),b.RangeSelector=p)});G(p,"parts/StockChart.js",[p["parts/Globals.js"],p["parts/Utilities.js"]],function(b,n){var p=n.defined,w=n.isNumber,B=n.isString,D=n.splat;n=b.addEvent;var z=b.arrayMax,y=b.arrayMin,k=b.Axis,A=b.Chart,e=b.extend,r=b.format,E=b.merge,q=b.pick,l=b.Point,a=b.Renderer,f=b.Series,
h=b.SVGRenderer,x=b.VMLRenderer,d=f.prototype,m=d.init,u=d.processData,v=l.prototype.tooltipFormatter;b.StockChart=b.stockChart=function(a,d,e){var c=B(a)||a.nodeName,g=arguments[c?1:0],f=g,h=g.series,k=b.getOptions(),l,t=q(g.navigator&&g.navigator.enabled,k.navigator.enabled,!0),m=t?{startOnTick:!1,endOnTick:!1}:null;g.xAxis=D(g.xAxis||{}).map(function(a,c){return E({minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0},k.xAxis,k.xAxis&&
k.xAxis[c],a,{type:"datetime",categories:null},m)});g.yAxis=D(g.yAxis||{}).map(function(a,c){l=q(a.opposite,!0);return E({labels:{y:-2},opposite:l,showLastLabel:!(!a.categories&&"category"!==a.type),title:{text:null}},k.yAxis,k.yAxis&&k.yAxis[c],a)});g.series=null;g=E({chart:{panning:!0,pinchType:"x"},navigator:{enabled:t},scrollbar:{enabled:q(k.scrollbar.enabled,!0)},rangeSelector:{enabled:q(k.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:q(k.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},
g,{isStock:!0});g.series=f.series=h;return c?new A(a,g,e):new A(g,d)};n(f,"setOptions",function(a){function c(a){return b.seriesTypes[a]&&d instanceof b.seriesTypes[a]}var d=this,e;this.chart.options.isStock&&(c("column")||c("columnrange")?e={borderWidth:0,shadow:!1}:!c("line")||c("scatter")||c("sma")||(e={marker:{enabled:!1,radius:2}}),e&&(a.plotOptions[this.type]=E(a.plotOptions[this.type],e)))});n(k,"autoLabelAlign",function(a){var c=this.chart,b=this.options;c=c._labelPanes=c._labelPanes||{};
var d=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(b=b.top+","+b.height,!c[b]&&d.enabled&&(15===d.x&&(d.x=0),void 0===d.align&&(d.align="right"),c[b]=this,a.align="right",a.preventDefault()))});n(k,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});n(k,"getPlotLinePath",function(a){function c(a){var c="xAxis"===a?"yAxis":"xAxis";a=d.options[c];return w(a)?[f[c][a]]:
B(a)?[f.get(a)]:e.map(function(a){return a[c]})}var d=this,e=this.isLinked&&!this.series?this.linkedParent.series:this.series,f=d.chart,h=f.renderer,k=d.left,l=d.top,m,n,r,u,v=[],x=[],y=a.translatedValue,z=a.value,A=a.force;if(f.options.isStock&&!1!==a.acrossPanes&&"xAxis"===d.coll||"yAxis"===d.coll){a.preventDefault();x=c(d.coll);var E=d.isXAxis?f.yAxis:f.xAxis;E.forEach(function(a){if(p(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var c=a.isXAxis?"yAxis":"xAxis";c=p(a.options[c])?f[c][a.options[c]]:
f[c][0];d===c&&x.push(a)}});var D=x.length?[]:[d.isXAxis?f.yAxis[0]:f.xAxis[0]];x.forEach(function(a){-1!==D.indexOf(a)||b.find(D,function(c){return c.pos===a.pos&&c.len===a.len})||D.push(a)});var G=q(y,d.translate(z,null,null,a.old));w(G)&&(d.horiz?D.forEach(function(a){var c;n=a.pos;u=n+a.len;m=r=Math.round(G+d.transB);"pass"!==A&&(m<k||m>k+d.width)&&(A?m=r=Math.min(Math.max(k,m),k+d.width):c=!0);c||v.push("M",m,n,"L",r,u)}):D.forEach(function(a){var c;m=a.pos;r=m+a.len;n=u=Math.round(l+d.height-
G);"pass"!==A&&(n<l||n>l+d.height)&&(A?n=u=Math.min(Math.max(l,n),d.top+d.height):c=!0);c||v.push("M",m,n,"L",r,u)}));a.path=0<v.length?h.crispPolyLine(v,a.lineWidth||1):null}});h.prototype.crispPolyLine=function(a,b){var c;for(c=0;c<a.length;c+=6)a[c+1]===a[c+4]&&(a[c+1]=a[c+4]=Math.round(a[c+1])-b%2/2),a[c+2]===a[c+5]&&(a[c+2]=a[c+5]=Math.round(a[c+2])+b%2/2);return a};a===x&&(x.prototype.crispPolyLine=h.prototype.crispPolyLine);n(k,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=
this.crossLabel.hide())});n(k,"afterDrawCrosshair",function(a){var c,b;if(p(this.crosshair.label)&&this.crosshair.label.enabled&&this.cross){var d=this.chart,f=this.options.crosshair.label,h=this.horiz,k=this.opposite,l=this.left,m=this.top,n=this.crossLabel,u=f.format,v="",w="inside"===this.options.tickPosition,x=!1!==this.crosshair.snap,y=0,z=a.e||this.cross&&this.cross.e,B=a.point;var A=this.lin2log;if(this.isLog){a=A(this.min);var D=A(this.max)}else a=this.min,D=this.max;A=h?"center":k?"right"===
this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";n||(n=this.crossLabel=d.renderer.label(null,null,null,f.shape||"callout").addClass("highcharts-crosshair-label"+(this.series[0]&&" highcharts-color-"+this.series[0].colorIndex)).attr({align:f.align||A,padding:q(f.padding,8),r:q(f.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||n.attr({fill:f.backgroundColor||this.series[0]&&this.series[0].color||"#666666",stroke:f.borderColor||"","stroke-width":f.borderWidth||0}).css(e({color:"#ffffff",
fontWeight:"normal",fontSize:"11px",textAlign:"center"},f.style)));h?(A=x?B.plotX+l:z.chartX,m+=k?0:this.height):(A=k?this.width+l:0,m=x?B.plotY+m:z.chartY);u||f.formatter||(this.isDatetimeAxis&&(v="%b %d, %Y"),u="{value"+(v?":"+v:"")+"}");v=x?B[this.isXAxis?"x":"y"]:this.toValue(h?z.chartX:z.chartY);n.attr({text:u?r(u,{value:v},d.time):f.formatter.call(this,v),x:A,y:m,visibility:v<a||v>D?"hidden":"visible"});f=n.getBBox();if(h){if(w&&!k||!w&&k)m=n.y-f.height}else m=n.y-f.height/2;h?(c=l-f.x,b=l+
this.width-f.x):(c="left"===this.labelAlign?l:0,b="right"===this.labelAlign?l+this.width:d.chartWidth);n.translateX<c&&(y=c-n.translateX);n.translateX+f.width>=b&&(y=-(n.translateX+f.width-b));n.attr({x:A+y,y:m,anchorX:h?A:this.opposite?0:d.chartWidth,anchorY:h?this.opposite?d.chartHeight:0:m+f.height/2})}});d.init=function(){m.apply(this,arguments);this.setCompare(this.options.compare)};d.setCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(c,b){var d=this.compareValue;if(void 0!==
c&&void 0!==d)return c="value"===a?c-d:c/d*100-(100===this.options.compareBase?0:100),b&&(b.change=c),c}:null;this.userOptions.compare=a;this.chart.hasRendered&&(this.isDirty=!0)};d.processData=function(a){var c,b=-1,d=!0===this.options.compareStart?0:1;u.apply(this,arguments);if(this.xAxis&&this.processedYData){var e=this.processedXData;var f=this.processedYData;var h=f.length;this.pointArrayMap&&(b=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(c=0;c<h-d;c++){var k=
f[c]&&-1<b?f[c][b]:f[c];if(w(k)&&e[c+d]>=this.xAxis.min&&0!==k){this.compareValue=k;break}}}};n(f,"afterGetExtremes",function(){if(this.modifyValue){var a=[this.modifyValue(this.dataMin),this.modifyValue(this.dataMax)];this.dataMin=y(a);this.dataMax=z(a)}});k.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(c){c.setCompare(a)}),q(b,!0)&&this.chart.redraw())};l.prototype.tooltipFormatter=function(a){a=a.replace("{point.change}",(0<this.change?"+":"")+b.numberFormat(this.change,
q(this.series.tooltipOptions.changeDecimals,2)));return v.apply(this,[a])};n(f,"render",function(){var a=this.chart;if(!(a.is3d&&a.is3d()||a.polar)&&this.xAxis&&!this.xAxis.isRadial){var b=this.yAxis.len;if(this.xAxis.axisLine){var d=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,e=Math.floor(this.xAxis.axisLine.strokeWidth()/2);0<=d&&(b-=Math.max(e-d,0))}!this.clipBox&&this.animate?(this.clipBox=E(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=b):a[this.sharedClipKey]&&(a[this.sharedClipKey].animate({width:this.xAxis.len,
height:b}),a[this.sharedClipKey+"m"]&&a[this.sharedClipKey+"m"].animate({width:this.xAxis.len}))}});n(A,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(E(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)})});G(p,"masters/modules/stock.src.js",[],function(){})});
//# sourceMappingURL=stock.js.map