<div class="page-header">
    <div class="row align-items-center">
        <div class="col">
            <h3 class="page-title">Utilisateurs</h3>
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?=base_url()?>dashboard">Tableau de bord</a></li>
                <li class="breadcrumb-item ">Sécurité</li>
                <li class="breadcrumb-item active">utilisateur</li>
            </ul>
        </div>
    </div>
</div>

<!-- <div class="row">
     <div class="col-12 col-md-6 col-lg-1" style="margin-bottom: 15px">
        <button type="submit" id="active_tout" class="btn btn-rounded btn-success" id="loadingModal">Activer</button>
    </div>
    
    <div class="col-12 col-md-6 col-lg-1" style="margin-bottom: 15px">
        <button type="submit" id="desactive_tout" class="btn btn-rounded btn-danger" id="loadingModal">Désactiver</button>
    </div>
</div> -->


<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-body">
                <div class="page-header">
                    <div class="row align-items-center">
                            <div class="col">
                                <h3 class="page-title">Liste des utilisateurs</h3>
                            </div>
                            <div class="col-auto text-end float-end ms-auto download-grp">
                                <button type="submit" id="active_tout" class="btn btn-rounded btn-success" disabled >Activer</button>
                            </div>
                            
                            <div class="col-auto text-end float-end ms-auto download-grp">
                            <button type="submit" id="desactive_tout" class="btn btn-rounded btn-danger" disabled >Désactiver</button>
                            </div>
                    </div>
                </div>
                <div class="table-responsive">
                <form action="#" id="form_check">
                    <table id="datatable" class="table border-0 star-student table-hover table-center mb-0 datatable table-striped">
                        <thead class="student-thread">
                            <tr>
                                <th>
                                    <div class="form-check check-tables">
                                        <input class="form-check-input check_all" type="checkbox" >
                                    </div>
                                </th>
                                <th>Prenom Nom</th>
                                <th>Profil</th>
                                <th>Téléphone</th>
                                <th>Email</th>
                                <th>Sexe</th>
                                <th>Structure</th>
                                <th>Etat</th>
                                <th class="text-end">Action</th>
                            </tr>
                        </thead>
                    <tbody>
                    
                    <?php foreach ($all_data as $value)
					{ ?>
                        <tr>
                            <td>
                                
                                    <div class="form-check check-tables">
                                        <input class="form-check-input id_check" name="id_checks[]" type="checkbox" id="id_check_<?=$value->id_personnel; ?>" value="<?=$value->id_personnel; ?>">
                                    </div>
                                
                            </td>
                            <td><?=strtoupper($value->prenom_personnel).' '.strtoupper($value->nom_personnel) ; ?></td>
                            <td><?=$value->libelle_type_profil; ?></td>
                            <td><?=$value->tel_personnel; ?></td>
                            <td><?=$value->email_personnel; ?></td>
                            <td>
                                <?php
                                    if($value->sexe_personnel =='H')
                                    {
                                ?>
                                        <h2 class="table-avatar">
                                            <a href="#" class="avatar avatar-sm me-2"><img class="avatar-img rounded-circle" src="<?php echo base_url(); ?>assets/images/H.png" alt="User Image"></a>
                                            <a href="#">Homme</a>
                                        </h2>
                                <?php
                                    } 
                                    elseif($value->sexe_personnel == 'F')
                                    {
                                ?>
                                        <h2 class="table-avatar">
                                            <a href="#" class="avatar avatar-sm me-2"><img class="avatar-img rounded-circle" src="<?php echo base_url(); ?>assets/images/F.png" alt="User Image"></a>
                                            <a href="#">Femme</a>
                                        </h2>
                                <?php
                                    }
                                ?>
                            </td>
                            <td><?=$value->libelle_structure; ?></td>
                            <td>
                                <?php
                                    if($value->statut == '1')
                                    {
                                ?>
                                        <span class="badge badge-soft-success">Actif</span>
                                <?php 
                                    }
                                    else
                                    {
                                ?>
                                        <span class="badge badge-soft-danger">Inactif</span>
                                <?php  
                                    }
                                ?>
                            </td>
                            <td style="width: 1%; white-space: nowrap">
                                <a class="reset_pw" id="<?= $value->id?>" tel="<?=$value->tel_personnel; ?>" email="<?=$value->email_personnel; ?>" href="#" >
                                    <i style="color:#000;" class="fe fe-send "></i>
                                </a>
                            </td>
                        </tr>
                    <?php
                    }
					?>
                    </tbody>
                </table>
                </form>
            </div>
        </div>
    </div>

</div> <!-- End Row -->


<div id="modal_form" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modal_formLabel"
     aria-hidden="true">
    <form action="#" id="form" class="form-horizontal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    <h4 class="modal-title" id="modal_formLabel">Title</h4>
                </div>
                <div class="modal-body">

                  <!--  <input type="hidden" name="statut" id="statut" />
                    <input type="hidden" name="code_acces" id="code_acces" />
                    <input type="hidden" name="email_pro" id="email_pro" />-->

                    <div class="form-body">
                        <div class="form-group">

                            <label class="control-label col-md-3">Ien</label>

                            <div class="col-md-9">
                                <input name="ien" id="ien"
                                       class="form-control" type="text" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-md-3">Profile</label>

                            <div class="col-md-9">
                                <select name="id_profil" id="id_profil" class="form-control" required>
                                        <?php echo $select_profile; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="submit" class="btn btn-primary" value="Enregistrer"/>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Fermer</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </form>
</div><!-- /.modal -->


<script type="text/javascript">
    $(document).ready(function (){

        

        $('.check_all').click(function(){
            if($(this).prop("checked") == true)
            {
                $('.id_check').prop("checked", true);
                $('#active_tout').attr("disabled", false);
                $('#desactive_tout').attr("disabled", false);
                
            }
            else
            {
                $('.id_check').prop("checked", false);
                $('#active_tout').attr("disabled", true);
                $('#desactive_tout').attr("disabled", true);
                
            }
        });

        $('.id_check').click(function()
        {
            $('.id_check').each(function() 
            {
                if($('.id_check').prop("checked") == true)
                {
                    $('#active_tout').attr("disabled", false);
                    $('#desactive_tout').attr("disabled", false);
                } 
                else
                {
                    $('#active_tout').attr("disabled", true);
                    $('#desactive_tout').attr("disabled", true);
                }
            });
        });

        $("#active_tout").click(function()
        {
            var url="<?=site_url('sys/C_sys_user/tout_activer')?>";
            var formulaire = $("#form_check");
            var isvalidate = $('#form_check').valid();
            if (isvalidate === true) {
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: formulaire.serialize(),
                    dataType: 'JSON',
                    success: function(data) {
                        if(data.length !== 0)
                        {
                            $.Notification.autoHideNotify('success', 'bottom right', 'Alerte', 'Les profils sélectionnés sont activés ');
                            $('#'+menu_encours).click();
                        }
                        else
                        {
                            $.Notification.autoHideNotify('error', 'bottom right', 'Alerte', 'Veuillez selectionner les profils à activer !');
                            $('#'+menu_encours).click();
                        }
                    },
                    error: function(jqXHR) {
                        $.Notification.autoHideNotify('error', 'bottom right', 'Alerte', 'Veuillez selectionners les profils à activer !');
                            $('#'+menu_encours).click();
                    }
                });
                return false;
            }

        });

        $("#desactive_tout").click(function()
        {
            var url="<?=site_url('sys/C_sys_user/tout_desactiver')?>";
            var formulaire = $("#form_check");
            var isvalidate = $('#form_check').valid();
            if (isvalidate === true) {
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: formulaire.serialize(),
                    dataType: 'JSON',
                    success: function(data) {
                        if(data.length !== 0)
                        {
                            $.Notification.autoHideNotify('success', 'bottom right', 'Alerte', 'Les profils sélectionnés sont désactivés');
                            $('#'+menu_encours).click();
                        }
                        else
                        {
                            $.Notification.autoHideNotify('error', 'bottom right', 'Alerte', 'Veuillez selectionners les profils à désactiver');
                            $('#'+menu_encours).click();
                        }
                    },
                    error: function(jqXHR) {
                        $.Notification.autoHideNotify('error', 'bottom right', 'Alerte', 'Veuillez selectionners les profils à désactiver');
                            $('#'+menu_encours).click()
                    }
                });
                return false;
            }

        });

        $(".reset_pw").click(function()
        {
            var id = $(this).attr('id');
            var url = '<?php echo site_url('sys/C_sys_user/reset_pw/')?>' + id ;            
            $.ajax({
                url: url,
                type: 'GET',
                dataType: 'JSON',
                success: function(data) 
                {
                    //console.log(data);exit;
                    if(data.status == 'success')
                    {
                        $.Notification.autoHideNotify('success', 'bottom right', 'Alerte', data.message);
                        $('#'+menu_encours).click();
                    }
                    else
                    {
                        $.Notification.autoHideNotify('error', 'bottom right', 'Alerte', data.message);
                        $('#'+menu_encours).click();
                    }
                },
                error: function(jqXHR) {
                    $.Notification.autoHideNotify('error', 'bottom right', 'Alerte', data.message);
                        $('#'+menu_encours).click()
                }
            });
        });

    });
</script>
