/*
 Highcharts JS v7.1.3 (2019-08-14)

 Support for parallel coordinates in Highcharts

 (c) 2010-2019 Pawel Fus

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/parallel-coordinates",["highcharts"],function(f){b(f);b.Highcharts=f;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function f(c,b,f,k){c.hasOwnProperty(b)||(c[b]=k.apply(null,f))}b=b?b._modules:{};f(b,"modules/parallel-coordinates.src.js",[b["parts/Globals.js"],b["parts/Utilities.js"]],function(c,b){function f(a){var d=
this.series&&this.series.chart,m=a.apply(this,Array.prototype.slice.call(arguments,1)),b;if(d&&d.hasParallelCoordinates&&!k(m.formattedValue)){var g=d.yAxis[this.x];var e=g.options;d=(b=q(e.tooltipValueFormat,e.labels.format))?c.format(b,n(this,{value:this.y}),d.time):g.isDatetimeAxis?d.time.dateFormat(d.time.resolveDTLFormat(e.dateTimeLabelFormats[g.tickPositions.info.unitName]).main,this.y):e.categories?e.categories[this.y]:this.y;m.formattedValue=m.point.formattedValue=d}return m}var k=b.defined,
v=b.erase,r=b.splat;b=c.Axis;var p=c.Chart,w=p.prototype,t=c.Axis.prototype,h=c.addEvent,q=c.pick,x=c.wrap,l=c.merge,n=c.extend,y=c.arrayMin,z=c.arrayMax,u={lineWidth:0,tickLength:0,opposite:!0,type:"category"};c.setOptions({chart:{parallelCoordinates:!1,parallelAxes:{lineWidth:1,title:{text:"",reserveSpace:!1},labels:{x:0,y:4,align:"center",reserveSpace:!1},offset:0}}});h(p,"init",function(a){a=a.args[0];var d=r(a.yAxis||{}),b=d.length,c=[];if(this.hasParallelCoordinates=a.chart&&a.chart.parallelCoordinates){for(this.setParallelInfo(a);b<=
this.parallelInfo.counter;b++)c.push({});a.legend||(a.legend={});void 0===a.legend.enabled&&(a.legend.enabled=!1);l(!0,a,{boost:{seriesThreshold:Number.MAX_VALUE},plotOptions:{series:{boostThreshold:Number.MAX_VALUE}}});a.yAxis=d.concat(c);a.xAxis=l(u,r(a.xAxis||{})[0])}});h(p,"update",function(a){a=a.options;a.chart&&(k(a.chart.parallelCoordinates)&&(this.hasParallelCoordinates=a.chart.parallelCoordinates),this.options.chart.parallelAxes=l(this.options.chart.parallelAxes,a.chart.parallelAxes));this.hasParallelCoordinates&&
(a.series&&this.setParallelInfo(a),this.yAxis.forEach(function(a){a.update({},!1)}))});n(w,{setParallelInfo:function(a){var d=this;a=a.series;d.parallelInfo={counter:0};a.forEach(function(a){a.data&&(d.parallelInfo.counter=Math.max(d.parallelInfo.counter,a.data.length-1))})}});t.keepProps.push("parallelPosition");h(b,"afterSetOptions",function(a){var d=this.chart,b=["left","width","height","top"];d.hasParallelCoordinates&&(d.inverted&&(b=b.reverse()),this.isXAxis?this.options=l(this.options,u,a.userOptions):
(this.options=l(this.options,this.chart.options.chart.parallelAxes,a.userOptions),this.parallelPosition=q(this.parallelPosition,d.yAxis.length),this.setParallelPosition(b,this.options)))});h(b,"getSeriesExtremes",function(a){if(this.chart&&this.chart.hasParallelCoordinates&&!this.isXAxis){var d=this.parallelPosition,b=[];this.series.forEach(function(a){a.visible&&k(a.yData[d])&&b.push(a.yData[d])});this.dataMin=y(b);this.dataMax=z(b);a.preventDefault()}});n(t,{setParallelPosition:function(a,b){var d=
(this.parallelPosition+.5)/(this.chart.parallelInfo.counter+1);this.chart.polar?b.angle=360*d:(b[a[0]]=100*d+"%",this[a[1]]=b[a[1]]=0,this[a[2]]=b[a[2]]=null,this[a[3]]=b[a[3]]=null)}});h(c.Series,"bindAxes",function(a){if(this.chart.hasParallelCoordinates){var b=this;this.chart.axes.forEach(function(a){b.insert(a.series);a.isDirty=!0});b.xAxis=this.chart.xAxis[0];b.yAxis=this.chart.yAxis[0];a.preventDefault()}});h(c.Series,"afterTranslate",function(){var a=this.chart,b=this.points,c=b&&b.length,
f=Number.MAX_VALUE,g;if(this.chart.hasParallelCoordinates){for(g=0;g<c;g++){var e=b[g];if(k(e.y)){e.plotX=a.polar?a.yAxis[g].angleRad||0:a.inverted?a.plotHeight-a.yAxis[g].top+a.plotTop:a.yAxis[g].left-a.plotLeft;e.clientX=e.plotX;e.plotY=a.yAxis[g].translate(e.y,!1,!0,null,!0);void 0!==h&&(f=Math.min(f,Math.abs(e.plotX-h)));var h=e.plotX;e.isInside=a.isInsidePlot(e.plotX,e.plotY,a.inverted)}else e.isNull=!0}this.closestPointRangePx=f}},{order:1});c.addEvent(c.Series,"destroy",function(){this.chart.hasParallelCoordinates&&
(this.chart.axes||[]).forEach(function(a){a&&a.series&&(v(a.series,this),a.isDirty=a.forceRedraw=!0)},this)});["line","spline"].forEach(function(a){x(c.seriesTypes[a].prototype.pointClass.prototype,"getLabelConfig",f)})});f(b,"masters/modules/parallel-coordinates.src.js",[],function(){})});
//# sourceMappingURL=parallel-coordinates.js.map