<div class="row">
     <div class="col-sm-1.5" style="margin-bottom: 15px">
        <button type="button" id="btn_add" class="btn btn-rounded btn-primary" id="loadingModal">Nouveau</button>
    </div>
</div>

<div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title mb-2">Liste des sous menus </h3>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable-buttons" class="datatable table table-stripped table-bordered">
                        <thead>
                        <tr>
                            <th style="width: 15%">Menu</th>
                            <th style="width: 15%">Code</th>
                            <th style="width: 60%">Libellé</th>
                            <th>Actions</th>
                        </tr>

                        </thead>
                        <tbody>
                        <?php
                       // var_dump($select_data_menu);
                       // exit();
                        ?>
                        <?php foreach ($sous_menu_liste as $value): ?>
                            <tr>
                                <td><?= $value->menu ?></td>
                                <td><?= $value->code ?></td>
                                <td><?= $value->libelle ?></td>

                                <td style="width: 10%">
                                    <?php btn_edit_action($value->id_sous_menu, 'LST_S_MENU'); ?> &nbsp;
                                    <?php btn_delete_action($value->id_sous_menu, 'LST_S_MENU'); ?>&nbsp;
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>


    <!-- sample modal content -->
    <div id="modal_form" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="standard-modalLabel" aria-hidden="true">
        <form action="#" id="form">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="standard-modalLabel">Title</h4>
                        <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">×</button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="id_sous_menu" name="id_sous_menu"/>

                        <div class="form-body">

                            <div class="form-group row">
                                <label class="col-lg-3 col-form-label">Menu <span class="text-danger">*</span></label>

                                <div class="col-lg-9">
                                    <select name="id_menu" id="id_menu" class="form-control select" required>
                                        <?php echo $select_data_menu; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-lg-3 col-form-label">Code <span class="text-danger">*</span></label>

                                <div class="col-lg-9">
                                    <input name="code" id="code" type="text"
                                           class="form-control" required>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-lg-3 col-form-label">Libelle <span class="text-danger">*</span></label>

                                <div class="col-lg-9">
                                    <input name="libelle" id="libelle" type="text"
                                           class="form-control" required>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                    <button type="button" id="close-btn" class="btn btn-danger float-left">Fermer</button>
                        <button type="submit" class="btn btn-primary">Enrégistrer</button>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </form>
    </div><!-- /.modal -->


    <script type="text/javascript">

        $(document).ready(function () {

            $('#datatable-buttons').managing_ajax({
                id_modal_form: 'modal_form',

                id_form: 'form',
                url_submit: "<?php echo site_url('sys/C_sys_menu/save_sous_menu')?>",

                title_modal_add: 'Ajouter un menu',
                focus_add: 'code',

                title_modal_edit: 'Modifier un menu',
                focus_edit: 'libelle',

                url_edit: "<?php echo site_url('sys/C_sys_menu/get_record_sous_menu')?>",
                url_delete: "<?php echo site_url('sys/C_sys_menu/delete_sous_menu')?>",
            });

            $('.btn-close').click(function(){
                //alert('ok');
                $('#modal_form').modal('hide');
            });
            
            $('#close-btn').click(function(){
                //alert('ok');
                $('#modal_form').modal('hide');
            });

        });

    </script>
<?php if (ENVIRONMENT !== 'production'): ?>{elapsed_time} seconds&nbsp;|&nbsp;{memory_usage}<?php endif ?>