/*
 Highcharts JS v7.1.3 (2019-08-14)

 Accessibility module

 (c) 2010-2019 Highsoft AS
 Author: Oystein Moseng

 License: www.highcharts.com/license
*/
(function(f){"object"===typeof module&&module.exports?(f["default"]=f,module.exports=f):"function"===typeof define&&define.amd?define("highcharts/modules/accessibility",["highcharts"],function(n){f(n);f.Highcharts=n;return f}):f("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(f){function n(c,f,l,h){c.hasOwnProperty(f)||(c[f]=h.apply(null,l))}f=f?f._modules:{};n(f,"modules/accessibility/KeyboardNavigationHandler.js",[f["parts/Globals.js"]],function(c){function f(c,b){this.chart=c;this.keyCodeMap=
b.keyCodeMap||[];this.validate=b.validate;this.init=b.init;this.terminate=b.terminate;this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}var l=c.find;f.prototype={run:function(c){var b=c.which||c.keyCode,a=this.response.noHandler,d=l(this.keyCodeMap,function(a){return-1<a[0].indexOf(b)});d?a=d[1].call(this,b,c):9===b?a=this.response[c.shiftKey?"prev":"next"]:27===b&&(this.chart&&this.chart.tooltip&&this.chart.tooltip.hide(0),a=this.response.success);return a}};return f});n(f,"modules/accessibility/AccessibilityComponent.js",
[f["parts/Globals.js"]],function(c){function f(){}var l=c.win,h=l.document,b=c.merge,a=c.addEvent;f.prototype={initBase:function(a){this.chart=a;this.eventRemovers=[];this.domElements=[];this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9};this.hiddenStyle={position:"absolute",width:"1px",height:"1px",overflow:"hidden"}},addEvent:function(){var a=c.addEvent.apply(c,arguments);this.eventRemovers.push(a);return a},createElement:function(){var a=c.win.document.createElement.apply(c.win.document,
arguments);this.domElements.push(a);return a},cloneMouseEvent:function(a){if("function"===typeof l.MouseEvent)return new l.MouseEvent(a.type,a);if(h.createEvent){var b=h.createEvent("MouseEvent");if(b.initMouseEvent)return b.initMouseEvent(a.type,"click"===a.type||a.canBubble,a.cancelable,a.view,a.detail,a.screenX,a.screenY,a.clientX,a.clientY,a.ctrlKey,a.altKey,a.shiftKey,a.metaKey,a.button,a.relatedTarget),b;b=h.createEvent("Event");if(b.initEvent)return b.initEvent(a.type,!0,!0),b}},fakeClickEvent:function(a){if(a&&
a.onclick&&h.createEvent){var b=h.createEvent("Event");b.initEvent("click",!0,!1);a.onclick(b)}},createProxyButton:function(d,e,k,c,g){var m=d.element,v=this,p=this.createElement("button"),h=b({"aria-label":m.getAttribute("aria-label")},k);if(d=this.getElementPosition(c||d))return Object.keys(h).forEach(function(a){null!==h[a]&&p.setAttribute(a,h[a])}),b(!0,p.style,{"border-width":0,"background-color":"transparent",position:"absolute",width:(d.width||1)+"px",height:(d.height||1)+"px",display:"block",
cursor:"pointer",overflow:"hidden",outline:"none",opacity:.001,filter:"alpha(opacity=1)","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",zIndex:999,padding:0,margin:0,left:d.x+"px",top:d.y-this.chart.chartHeight+"px"}),g&&a(p,"click",g),["click","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(g){a(p,g,function(a){var b=v.cloneMouseEvent(a);if(m)if(b)m.fireEvent?m.fireEvent(b):m.dispatchEvent&&m.dispatchEvent(b);else if(m["on"+g])m["on"+g](a)})}),e.appendChild(p),
h["aria-hidden"]||this.unhideElementFromScreenReaders(p),p},getElementPosition:function(a){var b=a.element;if((a=this.chart.renderTo)&&b&&b.getBoundingClientRect)return b=b.getBoundingClientRect(),a=a.getBoundingClientRect(),{x:b.left-a.left,y:b.top-a.top,width:b.right-b.left,height:b.bottom-b.top}},addProxyGroup:function(a){var b=this.chart;b.a11yProxyContainer||(b.a11yProxyContainer=h.createElement("div"),b.a11yProxyContainer.style.position="relative");b.container.nextSibling!==b.a11yProxyContainer&&
b.renderTo.insertBefore(b.a11yProxyContainer,b.container.nextSibling);var d=this.createElement("div");Object.keys(a||{}).forEach(function(b){null!==a[b]&&d.setAttribute(b,a[b])});b.a11yProxyContainer.appendChild(d);return d},removeElement:function(a){a&&a.parentNode&&a.parentNode.removeChild(a)},unhideElementFromScreenReaders:function(a){a.setAttribute("aria-hidden",!1);a!==this.chart.renderTo&&a.parentNode&&(Array.prototype.forEach.call(a.parentNode.childNodes,function(a){a.hasAttribute("aria-hidden")||
a.setAttribute("aria-hidden",!0)}),this.unhideElementFromScreenReaders(a.parentNode))},destroyBase:function(){var a=this;this.removeElement((this.chart||{}).a11yProxyContainer);this.eventRemovers.forEach(function(a){a()});this.domElements.forEach(function(b){a.removeElement(b)});this.eventRemovers=[];this.domElements=[]},stripTags:function(a){return"string"===typeof a?a.replace(/<\/?[^>]+(>|$)/g,""):a},htmlencode:function(a){return a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,
"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")},init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){this.destroyBase()}};return f});n(f,"modules/accessibility/KeyboardNavigation.js",[f["parts/Globals.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(c,f){function l(a,b,d){this.init(a,b,d)}var h=c.merge,b=c.addEvent,a=c.win,d=a.document;l.prototype={init:function(a,k){var e=this;this.chart=a;this.components=
k;this.modules=[];this.currentModuleIx=0;a.container.hasAttribute("tabIndex")||a.container.setAttribute("tabindex","0");this.addExitAnchor();this.unbindKeydownHandler=b(a.renderTo,"keydown",function(a){e.onKeydown(a)});this.unbindMouseUpHandler=b(d,"mouseup",function(){e.onMouseUp()});this.update();this.modules.length&&this.modules[0].init(1)},update:function(a){var b=this.chart.options.accessibility;b=b&&b.keyboardNavigation;var d=this.components;b&&b.enabled&&a&&a.length?this.modules=a.reduce(function(a,
b){b=d[b].getKeyboardNavigation();return b.length?a.concat(b):(a.push(b),a)},[new f(this.chart,{})]):(this.modules=[],this.currentModuleIx=0)},onMouseUp:function(){if(!(this.keyboardReset||this.chart.pointer&&this.chart.pointer.chartPosition)){var a=this.chart,b=this.modules&&this.modules[this.currentModuleIx||0];b&&b.terminate&&b.terminate();a.focusElement&&a.focusElement.removeFocusBorder();this.currentModuleIx=0;this.keyboardReset=!0}},onKeydown:function(b){b=b||a.event;var d,e=this.modules&&this.modules.length&&
this.modules[this.currentModuleIx];this.keyboardReset=!1;if(e){var g=e.run(b);g===e.response.success?d=!0:g===e.response.prev?d=this.prev():g===e.response.next&&(d=this.next());d&&b.preventDefault()}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(a){var b=this.modules&&this.modules[this.currentModuleIx];b&&b.terminate&&b.terminate(a);this.chart.focusElement&&this.chart.focusElement.removeFocusBorder();this.currentModuleIx+=a;if(b=this.modules&&this.modules[this.currentModuleIx]){if(b.validate&&
!b.validate())return this.move(a);if(b.init)return b.init(a),!0}this.currentModuleIx=0;0<a?(this.exiting=!0,this.exitAnchor.focus()):this.chart.renderTo.focus();return!1},addExitAnchor:function(){var e=this.chart,k=this.exitAnchorWrapper=d.createElement("div"),c=this.exitAnchor=d.createElement("h6"),g=this,m=e.langFormat("accessibility.svgContainerEnd",{chart:e});c.innerHTML=m;k.setAttribute("aria-hidden","false");k.setAttribute("class","highcharts-exit-anchor-wrapper");k.style.position="relative";
k.style.outline="none";c.setAttribute("tabindex","0");c.setAttribute("aria-hidden",!1);h(!0,c.style,{position:"absolute",width:"1px",height:"1px",bottom:"5px",zIndex:0,overflow:"hidden",outline:"none"});k.appendChild(c);e.renderTo.appendChild(k);this.unbindExitAnchorUpdate=b(e,"render",function(){this.renderTo.appendChild(k)});this.unbindExitAnchorFocus=b(c,"focus",function(b){b=b||a.event;g.exiting?g.exiting=!1:(e.renderTo.focus(),b.preventDefault(),g.modules&&g.modules.length&&(g.currentModuleIx=
g.modules.length-1,(b=g.modules[g.currentModuleIx])&&b.validate&&!b.validate()?g.prev():b&&b.init(-1)))})},destroy:function(){this.unbindExitAnchorFocus&&(this.unbindExitAnchorFocus(),delete this.unbindExitAnchorFocus);this.unbindExitAnchorUpdate&&(this.unbindExitAnchorUpdate(),delete this.unbindExitAnchorUpdate);this.exitAnchorWrapper&&this.exitAnchorWrapper.parentNode&&(this.exitAnchorWrapper.parentNode.removeChild(this.exitAnchorWrapper),delete this.exitAnchor,delete this.exitAnchorWrapper);this.unbindKeydownHandler&&
this.unbindKeydownHandler();this.unbindMouseUpHandler&&this.unbindMouseUpHandler()}};return l});n(f,"modules/accessibility/components/LegendComponent.js",[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(c,f,l){c.Chart.prototype.highlightLegendItem=function(b){var a=this.legend.allItems,d=this.highlightedLegendItemIx;return a[b]?(a[d]&&c.fireEvent(a[d].legendGroup.element,"mouseout"),void 0!==a[b].pageIx&&
a[b].pageIx+1!==this.legend.currentPage&&this.legend.scroll(1+a[b].pageIx-this.legend.currentPage),this.setFocusToElement(a[b].legendItem,a[b].a11yProxyElement),c.fireEvent(a[b].legendGroup.element,"mouseover"),!0):!1};c.addEvent(c.Legend,"afterColorizeItem",function(b){var a=b.item;this.chart.options.accessibility.enabled&&a&&a.a11yProxyElement&&a.a11yProxyElement.setAttribute("aria-pressed",b.visible?"false":"true")});var h=function(b){this.initBase(b)};h.prototype=new f;c.extend(h.prototype,{onChartRender:function(){var b=
this.chart,a=b.options.accessibility,d=b.legend&&b.legend.allItems,e=this;e.legendProxyButtonClicked?delete e.legendProxyButtonClicked:(this.removeElement(this.legendProxyGroup),!d||!d.length||b.colorAxis&&b.colorAxis.length||!b.options.legend.accessibility.enabled||(this.legendProxyGroup=this.addProxyGroup({"aria-label":b.langFormat("accessibility.legendLabel"),role:"all"===a.landmarkVerbosity?"region":null}),d.forEach(function(a){a.legendItem&&a.legendItem.element&&(a.a11yProxyElement=e.createProxyButton(a.legendItem,
e.legendProxyGroup,{tabindex:-1,"aria-pressed":!a.visible,"aria-label":b.langFormat("accessibility.legendItem",{chart:b,itemName:e.stripTags(a.name)})},a.legendGroup.div?a.legendItem:a.legendGroup,function(){e.legendProxyButtonClicked=!0}))})))},getKeyboardNavigation:function(){var b=this.keyCodes,a=this,d=this.chart,e=d.options.accessibility;return new l(d,{keyCodeMap:[[[b.left,b.right,b.up,b.down],function(k){k=k===b.left||k===b.up?-1:1;return d.highlightLegendItem(a.highlightedLegendItemIx+k)?
(a.highlightedLegendItemIx+=k,this.response.success):1<d.legend.allItems.length&&e.keyboardNavigation.wrapAround?(this.init(k),this.response.success):this.response[0<k?"next":"prev"]}],[[b.enter,b.space],function(){var b=d.legend.allItems[a.highlightedLegendItemIx];b&&b.a11yProxyElement&&c.fireEvent(b.a11yProxyElement,"click");return this.response.success}]],validate:function(){var a=d.options.legend;return d.legend&&d.legend.allItems&&d.legend.display&&!(d.colorAxis&&d.colorAxis.length)&&a&&a.accessibility&&
a.accessibility.enabled&&a.accessibility.keyboardNavigation&&a.accessibility.keyboardNavigation.enabled},init:function(b){b=0<b?0:d.legend.allItems.length-1;d.highlightLegendItem(b);a.highlightedLegendItemIx=b}})}});return h});n(f,"modules/accessibility/components/MenuComponent.js",[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(c,f,l){c.Chart.prototype.showExportMenu=function(){this.exportSVGElements&&this.exportSVGElements[0]&&
(this.exportSVGElements[0].element.onclick(),this.highlightExportItem(0))};c.Chart.prototype.hideExportMenu=function(){var b=this.exportDivElements;b&&this.exportContextMenu&&(b.forEach(function(a){if("highcharts-menu-item"===a.className&&a.onmouseout)a.onmouseout()}),this.highlightedExportItemIx=0,this.exportContextMenu.hideMenu(),this.container.focus())};c.Chart.prototype.highlightExportItem=function(b){var a=this.exportDivElements&&this.exportDivElements[b],d=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx];
if(a&&"DIV"===a.tagName&&(!a.children||!a.children.length)){var e=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus;a.focus&&e&&a.focus();if(d&&d.onmouseout)d.onmouseout();if(a.onmouseover)a.onmouseover();this.highlightedExportItemIx=b;return!0}};c.Chart.prototype.highlightLastExportItem=function(){var b;if(this.exportDivElements)for(b=this.exportDivElements.length;b--;)if(this.highlightExportItem(b))return!0;return!1};var h=function(b){this.initBase(b);this.init()};h.prototype=new f;c.extend(h.prototype,
{init:function(){this.addEvent(this.chart,"exportMenuHidden",function(){var b=this.exportContextMenu;b&&b.setAttribute("aria-hidden",!0)})},onChartRender:function(){var b=this,a=this.chart,d=a.options.accessibility;this.removeElement(this.exportProxyGroup);if(a.options.exporting&&!1!==a.options.exporting.enabled&&a.options.exporting.accessibility&&a.options.exporting.accessibility.enabled&&a.exportSVGElements&&a.exportSVGElements[0]&&a.exportSVGElements[0].element){var e=a.exportSVGElements[0],k=
e.element,c=k.onclick;this.wrappedButton!==k&&(k.onclick=function(){c.apply(this,Array.prototype.slice.call(arguments));b.addAccessibleContextMenuAttribs();a.highlightExportItem(0)},this.wrappedButton=k);this.exportProxyGroup=this.addProxyGroup("all"===d.landmarkVerbosity?{"aria-label":a.langFormat("accessibility.exporting.exportRegionLabel",{chart:a}),role:"region"}:null);this.exportButtonProxy=this.createProxyButton(e,this.exportProxyGroup,{"aria-label":a.langFormat("accessibility.exporting.menuButtonLabel",
{chart:a})})}},addAccessibleContextMenuAttribs:function(){var b=this.chart,a=b.exportDivElements,d=b.exportContextMenu;a&&a.length&&(a.forEach(function(a){"DIV"!==a.tagName||a.children&&a.children.length||(a.setAttribute("role","menuitem"),a.setAttribute("tabindex",-1))}),a[0].parentNode.setAttribute("role","menu"),a[0].parentNode.setAttribute("aria-label",b.langFormat("accessibility.exporting.chartMenuLabel",{chart:b})));d&&this.unhideElementFromScreenReaders(d)},getKeyboardNavigation:function(){var b=
this.keyCodes,a=this.chart,d=a.options.accessibility,e=this;return new l(a,{keyCodeMap:[[[b.left,b.up],function(){for(var b=a.highlightedExportItemIx||0;b--;)if(a.highlightExportItem(b))return this.response.success;return d.keyboardNavigation.wrapAround?(a.highlightLastExportItem(),this.response.success):this.response.prev}],[[b.right,b.down],function(){for(var b=(a.highlightedExportItemIx||0)+1;b<a.exportDivElements.length;++b)if(a.highlightExportItem(b))return this.response.success;return d.keyboardNavigation.wrapAround?
(a.highlightExportItem(0),this.response.success):this.response.next}],[[b.enter,b.space],function(){e.fakeClickEvent(a.exportDivElements[a.highlightedExportItemIx]);return this.response.success}],[[b.esc],function(){return this.response.prev}]],validate:function(){return a.exportChart&&!1!==a.options.exporting.enabled&&!1!==a.options.exporting.accessibility.enabled},init:function(b){a.showExportMenu();0>b&&a.highlightLastExportItem()},terminate:function(){a.hideExportMenu()}})}});return h});n(f,"modules/accessibility/components/SeriesComponent.js",
[f["parts/Globals.js"],f["parts/Utilities.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(c,f,l,h){function b(a){var b=a.index,g=a.series.points,d=g.length;if(g[b]!==a)for(;d--;){if(g[d]===a)return d}else return b}function a(a){var b=a.chart.options.accessibility,g=a.options.accessibility||{},d=g.keyboardNavigation;return d&&!1===d.enabled||!1===g.enabled||!1===a.options.enableMouseTracking||!a.visible||b.pointNavigationThreshold&&
b.pointNavigationThreshold<=a.points.length}function d(b){var g=b.series.chart.options.accessibility;return b.isNull&&g.keyboardNavigation.skipNullPoints||!1===b.visible||a(b.series)}var e=f.isNumber,k=c.merge,t=c.pick;c.Series.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(a){c.seriesTypes[a]&&(c.seriesTypes[a].prototype.keyboardMoveVertical=!1)});c.addEvent(c.Series,"render",function(){var a=this.options,b=this.chart.options.accessibility||{},d=this.points||[],e=d.length,c=
this.resetA11yMarkerOptions;if(b.enabled&&!1!==(a.accessibility&&a.accessibility.enabled)&&(e<b.pointDescriptionThreshold||!1===b.pointDescriptionThreshold||e<b.pointNavigationThreshold||!1===b.pointNavigationThreshold)){if(a.marker&&!1===a.marker.enabled&&(this.a11yMarkersForced=!0,k(!0,this.options,{marker:{enabled:!0,states:{normal:{opacity:0}}}})),this._hasPointMarkers&&this.points&&this.points.length)for(a=e;a--;)b=d[a].options,b.marker&&(b.marker.enabled?k(!0,b.marker,{states:{normal:{opacity:b.marker.states&&
b.marker.states.normal&&b.marker.states.normal.opacity||1}}}):k(!0,b.marker,{enabled:!0,states:{normal:{opacity:0}}}))}else this.a11yMarkersForced&&c&&(delete this.a11yMarkersForced,k(!0,this.options,{marker:{enabled:c.enabled,states:{normal:{opacity:c.states&&c.states.normal&&c.states.normal.opacity}}}}))});c.addEvent(c.Series,"afterSetOptions",function(a){this.resetA11yMarkerOptions=k(a.options.marker||{},this.userOptions.marker||{})});c.Point.prototype.highlight=function(){var a=this.series.chart;
if(this.isNull)a.tooltip&&a.tooltip.hide(0);else this.onMouseOver();this.graphic&&a.setFocusToElement(this.graphic);a.highlightedPoint=this;return this};c.Chart.prototype.highlightAdjacentPoint=function(g){var m=this.series,e=this.highlightedPoint,c=e&&b(e)||0,k=e&&e.series.points,h=this.series&&this.series[this.series.length-1];h=h&&h.points&&h.points[h.points.length-1];if(!m[0]||!m[0].points)return!1;if(e){if(m=m[e.series.index+(g?1:-1)],c=k[c+(g?1:-1)],!c&&m&&(c=m.points[g?0:m.points.length-1]),
!c)return!1}else c=g?m[0].points[0]:h;return d(c)?(m=c.series,a(m)?this.highlightedPoint=g?m.points[m.points.length-1]:m.points[0]:this.highlightedPoint=c,this.highlightAdjacentPoint(g)):c.highlight()};c.Series.prototype.highlightFirstValidPoint=function(){var a=this.chart.highlightedPoint,e=(a&&a.series)===this?b(a):0;a=this.points;var c=a.length;if(a&&c){for(var k=e;k<c;++k)if(!d(a[k]))return a[k].highlight();for(;0<=e;--e)if(!d(a[e]))return a[e].highlight()}return!1};c.Chart.prototype.highlightAdjacentSeries=
function(b){var g,d,e=this.highlightedPoint,c=(g=this.series&&this.series[this.series.length-1])&&g.points&&g.points[g.points.length-1];if(!this.highlightedPoint)return g=b?this.series&&this.series[0]:g,(d=b?g&&g.points&&g.points[0]:c)?d.highlight():!1;g=this.series[e.series.index+(b?-1:1)];if(!g)return!1;c=Infinity;var k=g.points.length;if(void 0===e.plotX||void 0===e.plotY)d=void 0;else{for(;k--;){var h=g.points[k];void 0!==h.plotX&&void 0!==h.plotY&&(h=(e.plotX-h.plotX)*(e.plotX-h.plotX)*4+(e.plotY-
h.plotY)*(e.plotY-h.plotY),h<c&&(c=h,d=k))}d=void 0!==d&&g.points[d]}if(!d)return!1;if(a(g))return d.highlight(),b=this.highlightAdjacentSeries(b),b?b:(e.highlight(),!1);d.highlight();return d.series.highlightFirstValidPoint()};c.Chart.prototype.highlightAdjacentPointVertical=function(b){var g=this.highlightedPoint,e=Infinity,c;if(void 0===g.plotX||void 0===g.plotY)return!1;this.series.forEach(function(m){a(m)||m.points.forEach(function(a){if(void 0!==a.plotY&&void 0!==a.plotX&&a!==g){var k=a.plotY-
g.plotY,h=Math.abs(a.plotX-g.plotX);h=Math.abs(k)*Math.abs(k)+h*h*4;m.yAxis.reversed&&(k*=-1);!(0>=k&&b||0<=k&&!b||5>h||d(a))&&h<e&&(e=h,c=a)}})});return c?c.highlight():!1};c.Point.prototype.getA11yTimeDescription=function(){var a=this.series,b=a.chart,d=b.options.accessibility;if(a.xAxis&&a.xAxis.isDatetimeAxis)return b.time.dateFormat(d.pointDateFormatter&&d.pointDateFormatter(this)||d.pointDateFormat||c.Tooltip.prototype.getXDateFormat.call({getDateFormat:c.Tooltip.prototype.getDateFormat,chart:b},
this,b.options.tooltip,a.xAxis),this.x)};f=function(a){this.initBase(a);this.init()};f.prototype=new l;c.extend(f.prototype,{init:function(){var a=this;this.addEvent(c.Series,"destroy",function(){var b=this.chart;b===a.chart&&b.highlightedPoint&&b.highlightedPoint.series===this&&(delete b.highlightedPoint,b.focusElement&&b.focusElement.removeFocusBorder())});this.addEvent(c.Tooltip,"refresh",function(){this.chart===a.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",
!0)});this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(a){a.labelBySeries&&a.labelBySeries.attr("aria-hidden",!0)})});this.initAnnouncer()},onChartRender:function(){var a=this;this.chart.series.forEach(function(b){a[!1!==(b.options.accessibility&&b.options.accessibility.enabled)&&b.visible?"addSeriesDescription":"hideSeriesFromScreenReader"](b)})},getKeyboardNavigation:function(){var a=this.keyCodes,b=this.chart,d=b.inverted,e=b.options.accessibility,c=function(a){return b.highlightAdjacentPoint(a)?
this.response.success:e.keyboardNavigation.wrapAround?this.init(a?1:-1):this.response[a?"next":"prev"]};return new h(b,{keyCodeMap:[[[d?a.up:a.left,d?a.down:a.right],function(b){return c.call(this,b===a.right||b===a.down)}],[[d?a.left:a.up,d?a.right:a.down],function(d){d=d===a.down||d===a.right;var g=e.keyboardNavigation;if(g.mode&&"serialize"===g.mode)return c.call(this,d);b[b.highlightedPoint&&b.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries"](d);
return this.response.success}],[[a.enter,a.space],function(){b.highlightedPoint&&b.highlightedPoint.firePointEvent("click")}]],init:function(a){var d=b.series.length,g=0<a?0:d;if(0<a)for(delete b.highlightedPoint;g<d&&!(a=b.series[g].highlightFirstValidPoint());)++g;else for(;g--&&!(b.highlightedPoint=b.series[g].points[b.series[g].points.length-1],a=b.series[g].highlightFirstValidPoint()););return this.response.success},terminate:function(){b.tooltip&&b.tooltip.hide(0);delete b.highlightedPoint}})},
isPointClickable:function(a){var b=a.series.options||{};b=b.point&&b.point.events;return a&&a.graphic&&a.graphic.element&&(a.hcEvents&&a.hcEvents.click||b&&b.click||a.options&&a.options.events&&a.options.events.click)},initAnnouncer:function(){var a=this.chart,b=a.options.accessibility,d=this;this.lastAnnouncementTime=0;this.dirty={allSeries:{}};this.announceRegion=this.createElement("div");this.announceRegion.setAttribute("aria-hidden",!1);this.announceRegion.setAttribute("aria-live",b.announceNewData.interruptUser?
"assertive":"polite");k(!0,this.announceRegion.style,this.hiddenStyle);a.renderTo.insertBefore(this.announceRegion,a.renderTo.firstChild);this.addEvent(this.chart,"afterDrilldown",function(){a.highlightedPoint=null;if(a.options.accessibility.announceNewData.enabled){if(this.series&&this.series.length){var b=d.getSeriesElement(this.series[0]);b.focus&&b.getAttribute("aria-label")?b.focus():this.series[0].highlightFirstValidPoint()}d.lastAnnouncementTime=0;a.focusElement&&a.focusElement.removeFocusBorder()}});
this.addEvent(c.Series,"updatedData",function(){this.chart===a&&this.chart.options.accessibility.announceNewData.enabled&&(d.dirty.hasDirty=!0,d.dirty.allSeries[this.name+this.index]=this)});this.addEvent(a,"afterAddSeries",function(a){this.options.accessibility.announceNewData.enabled&&(a=a.series,d.dirty.hasDirty=!0,d.dirty.allSeries[a.name+a.index]=a,d.dirty.newSeries=void 0===d.dirty.newSeries?a:null)});this.addEvent(c.Series,"addPoint",function(b){this.chart===a&&this.chart.options.accessibility.announceNewData.enabled&&
(d.dirty.newPoint=void 0===d.dirty.newPoint?b.point:null)});this.addEvent(a,"redraw",function(){if(this.options.accessibility.announceNewData&&d.dirty.hasDirty){var a=d.dirty.newPoint;if(a){var b=a.series.data.filter(function(b){return b.x===a.x&&b.y===a.y});a=1===b.length?b[0]:a}d.announceNewData(Object.keys(d.dirty.allSeries).map(function(a){return d.dirty.allSeries[a]}),d.dirty.newSeries,a);d.dirty={allSeries:{}}}})},announceNewData:function(a,b,d){var e=this.chart.options.accessibility.announceNewData;
if(e.enabled){var g=this,c=+new Date;e=Math.max(0,e.minAnnounceInterval-(c-this.lastAnnouncementTime));if(this.queuedAnnouncement){var k=(this.queuedAnnouncement.series||[]).concat(a).reduce(function(a,b){a[b.name+b.index]=b;return a},{});a=Object.keys(k).map(function(a){return k[a]})}else a=[].concat(a);if(b=this.buildAnnouncementMessage(a,b,d))this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:c,message:b,series:a},g.queuedAnnouncementTimer=setTimeout(function(){g&&
g.announceRegion&&(g.lastAnnouncementTime=+new Date,g.announceRegion.innerHTML=g.queuedAnnouncement.message,g.clearAnnouncementContainerTimer&&clearTimeout(g.clearAnnouncementContainerTimer),g.clearAnnouncementContainerTimer=setTimeout(function(){g.announceRegion.innerHTML="";delete g.clearAnnouncementContainerTimer},1E3),delete g.queuedAnnouncement,delete g.queuedAnnouncementTimer)},e)}},buildAnnouncementMessage:function(a,b,d){var e=this.chart,g=e.options.accessibility.announceNewData;if(g.announcementFormatter&&
(a=g.announcementFormatter(a,b,d),!1!==a))return a.length?a:null;a=c.charts&&1<c.charts.length?"Multiple":"Single";return e.langFormat("accessibility.announceNewData."+(b?"newSeriesAnnounce"+a:d?"newPointAnnounce"+a:"newDataAnnounce"),{chartTitle:this.stripTags(e.options.title.text||e.langFormat("accessibility.defaultChartTitle",{chart:e})),seriesDesc:b?this.defaultSeriesDescriptionFormatter(b):null,pointDesc:d?this.defaultPointDescriptionFormatter(d):null,point:d,series:b})},reverseChildNodes:function(a){for(var b=
a.childNodes.length;b--;)a.appendChild(a.childNodes[b])},getSeriesFirstPointElement:function(a){return a.points&&a.points.length&&a.points[0].graphic&&a.points[0].graphic.element},getSeriesElement:function(a){var b=this.getSeriesFirstPointElement(a);return b&&b.parentNode||a.graph&&a.graph.element||a.group&&a.group.element},hideSeriesFromScreenReader:function(a){(a=this.getSeriesElement(a))&&a.setAttribute("aria-hidden",!0)},addSeriesDescription:function(a){var b=this,d=a.chart,e=d.options.accessibility,
g=a.options.accessibility||{},c=b.getSeriesFirstPointElement(a),k=b.getSeriesElement(a),h=a.points&&(a.points.length<e.pointDescriptionThreshold||!1===e.pointDescriptionThreshold)&&!g.exposeAsGroupOnly,f=a.points&&(a.points.length<e.pointNavigationThreshold||!1===e.pointNavigationThreshold);k&&(k.lastChild===c&&b.reverseChildNodes(k),b.unhideElementFromScreenReaders(k),(h||f)&&a.points.forEach(function(a){var d=a.graphic&&a.graphic.element;d&&(d.setAttribute("tabindex","-1"),h?(d.setAttribute("role",
"img"),d.setAttribute("aria-label",b.stripTags(g.pointDescriptionFormatter&&g.pointDescriptionFormatter(a)||e.pointDescriptionFormatter&&e.pointDescriptionFormatter(a)||b.defaultPointDescriptionFormatter(a)))):d.setAttribute("aria-hidden",!0))}),1<d.series.length||e.describeSingleSeries?(g.exposeAsGroupOnly?k.setAttribute("role","img"):"all"===e.landmarkVerbosity&&k.setAttribute("role","region"),k.setAttribute("tabindex","-1"),k.setAttribute("aria-label",b.stripTags(e.seriesDescriptionFormatter&&
e.seriesDescriptionFormatter(a)||b.defaultSeriesDescriptionFormatter(a)))):k.setAttribute("aria-label",""))},defaultSeriesDescriptionFormatter:function(a){var b=a.chart,d=(a.options.accessibility||{}).description;d=d&&b.langFormat("accessibility.series.description",{description:d,series:a});var e=b.langFormat("accessibility.series.xAxisDescription",{name:a.xAxis&&a.xAxis.getDescription(),series:a}),c=b.langFormat("accessibility.series.yAxisDescription",{name:a.yAxis&&a.yAxis.getDescription(),series:a}),
g={name:a.name||"",ix:a.index+1,numSeries:b.series&&b.series.length,numPoints:a.points&&a.points.length,series:a},k=b.types&&1<b.types.length?"Combination":"";return(b.langFormat("accessibility.series.summary."+a.type+k,g)||b.langFormat("accessibility.series.summary.default"+k,g))+(d?" "+d:"")+(b.yAxis&&1<b.yAxis.length&&this.yAxis?" "+c:"")+(b.xAxis&&1<b.xAxis.length&&this.xAxis?" "+e:"")},defaultPointDescriptionFormatter:function(a){var b=a.series,d=b.chart,k=d.options.accessibility,g=a.series.tooltipOptions||
{},h=k.pointValuePrefix||g.valuePrefix||"",f=k.pointValueSuffix||g.valueSuffix||"",l=a.options&&a.options.accessibility&&a.options.accessibility.description,n=a.getA11yTimeDescription(),r=function(a){if(e(a)){var b=c.defaultOptions.lang;return c.numberFormat(a,k.pointValueDecimals||g.valueDecimals||-1,b.decimalPoint,b.accessibility.thousandsSep||b.thousandsSep)}return a},w=t(b.xAxis&&b.xAxis.options.accessibility&&b.xAxis.options.accessibility.enabled,!d.angular),u=b.xAxis&&b.xAxis.categories&&void 0!==
a.category&&""+a.category;n=a.name||n||u&&u.replace("<br/>"," ")||(a.id&&0>a.id.indexOf("highcharts-")?a.id:"x, "+a.x);u=a.series.pointArrayMap?a.series.pointArrayMap.reduce(function(b,d){return b+(b.length?", ":"")+d+": "+h+r(t(a[d],a.options[d]))+f},""):void 0!==a.value?h+r(a.value)+f:h+r(a.y)+f;return(void 0!==a.index?a.index+1+". ":"")+(w?n+", ":"")+u+"."+(l?" "+l:"")+(1<d.series.length&&b.name?" "+b.name:"")}});return f});n(f,"modules/accessibility/components/ZoomComponent.js",[f["parts/Globals.js"],
f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(c,f,l){c.Axis.prototype.panStep=function(b,a){var d=a||3;a=this.getExtremes();var e=(a.max-a.min)/d*b;d=a.max+e;e=a.min+e;var c=d-e;0>b&&e<a.dataMin?(e=a.dataMin,d=e+c):0<b&&d>a.dataMax&&(d=a.dataMax,e=d-c);this.setExtremes(e,d)};var h=function(b){this.initBase(b);this.init()};h.prototype=new f;c.extend(h.prototype,{init:function(){var b=this,a=this.chart;["afterShowResetZoom","afterDrilldown",
"drillupall"].forEach(function(d){b.addEvent(a,d,function(){b.updateProxyOverlays()})})},onChartUpdate:function(){var b=this.chart,a=this;b.mapNavButtons&&b.mapNavButtons.forEach(function(d,e){a.unhideElementFromScreenReaders(d.element);d.element.setAttribute("tabindex",-1);d.element.setAttribute("role","button");d.element.setAttribute("aria-label",b.langFormat("accessibility.mapZoom"+(e?"Out":"In"),{chart:b}))})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var b=
this,a=this.chart,d=function(a,d,c,g){b.removeElement(b[c]);b[c]=b.addProxyGroup();b[d]=b.createProxyButton(a,b[c],{"aria-label":g,tabindex:-1})};b.removeElement(b.drillUpProxyGroup);b.removeElement(b.resetZoomProxyGroup);a.resetZoomButton&&d(a.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",a.langFormat("accessibility.resetZoomButton",{chart:a}));a.drillUpButton&&d(a.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",a.langFormat("accessibility.drillUpButton",{chart:a,buttonText:a.getDrilldownBackText()}))},
getMapZoomNavigation:function(){var b=this.keyCodes,a=this.chart,d=this;return new l(a,{keyCodeMap:[[[b.up,b.down,b.left,b.right],function(d){a[d===b.up||d===b.down?"yAxis":"xAxis"][0].panStep(d===b.left||d===b.up?-1:1);return this.response.success}],[[b.tab],function(b,c){a.mapNavButtons[d.focusedMapNavButtonIx].setState(0);if(c.shiftKey&&!d.focusedMapNavButtonIx||!c.shiftKey&&d.focusedMapNavButtonIx)return a.mapZoom(),this.response[c.shiftKey?"prev":"next"];d.focusedMapNavButtonIx+=c.shiftKey?-1:
1;b=a.mapNavButtons[d.focusedMapNavButtonIx];a.setFocusToElement(b.box,b.element);b.setState(2);return this.response.success}],[[b.space,b.enter],function(){d.fakeClickEvent(a.mapNavButtons[d.focusedMapNavButtonIx].element);return this.response.success}]],validate:function(){return a.mapZoom&&a.mapNavButtons&&2===a.mapNavButtons.length},init:function(b){var e=a.mapNavButtons[0],c=a.mapNavButtons[1];e=0<b?e:c;a.setFocusToElement(e.box,e.element);e.setState(2);d.focusedMapNavButtonIx=0<b?0:1}})},simpleButtonNavigation:function(b,
a,d){var e=this.keyCodes,c=this,h=this.chart;return new l(h,{keyCodeMap:[[[e.tab,e.up,e.down,e.left,e.right],function(a,b){return this.response[a===this.tab&&b.shiftKey||a===e.left||a===e.up?"prev":"next"]}],[[e.space,e.enter],function(){d(h);return this.response.success}]],validate:function(){return h[b]&&h[b].box&&c[a]},init:function(){h.setFocusToElement(h[b].box,c[a])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(b){b.zoomOut()}),
this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(b){b.drillUp()}),this.getMapZoomNavigation()]}});return h});n(f,"modules/accessibility/components/RangeSelectorComponent.js",[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigationHandler.js"]],function(c,f,l){c.Chart.prototype.highlightRangeSelectorButton=function(b){var a=this.rangeSelector.buttons;a[this.highlightedRangeSelectorItemIx]&&a[this.highlightedRangeSelectorItemIx].setState(this.oldRangeSelectorItemState||
0);this.highlightedRangeSelectorItemIx=b;return a[b]?(this.setFocusToElement(a[b].box,a[b].element),this.oldRangeSelectorItemState=a[b].state,a[b].setState(2),!0):!1};var h=function(b){this.initBase(b)};h.prototype=new f;c.extend(h.prototype,{onChartUpdate:function(){var b=this.chart,a=this,d=b.rangeSelector;d&&(d.buttons&&d.buttons.length&&d.buttons.forEach(function(d){a.unhideElementFromScreenReaders(d.element);d.element.setAttribute("tabindex","-1");d.element.setAttribute("role","button");d.element.setAttribute("aria-label",
b.langFormat("accessibility.rangeSelectorButton",{chart:b,buttonText:d.text&&d.text.textStr}))}),d.maxInput&&d.minInput&&["minInput","maxInput"].forEach(function(e,c){d[e]&&(a.unhideElementFromScreenReaders(d[e]),d[e].setAttribute("tabindex","-1"),d[e].setAttribute("role","textbox"),d[e].setAttribute("aria-label",b.langFormat("accessibility.rangeSelector"+(c?"MaxInput":"MinInput"),{chart:b})))}))},getRangeSelectorButtonNavigation:function(){var b=this.chart,a=this.keyCodes,d=b.options.accessibility,
e=this;return new l(b,{keyCodeMap:[[[a.left,a.right,a.up,a.down],function(e){e=e===a.left||e===a.up?-1:1;if(!b.highlightRangeSelectorButton(b.highlightedRangeSelectorItemIx+e))return d.keyboardNavigation.wrapAround?(this.init(e),this.response.success):this.response[0<e?"next":"prev"]}],[[a.enter,a.space],function(){3!==b.oldRangeSelectorItemState&&e.fakeClickEvent(b.rangeSelector.buttons[b.highlightedRangeSelectorItemIx].element)}]],validate:function(){return b.rangeSelector&&b.rangeSelector.buttons&&
b.rangeSelector.buttons.length},init:function(a){b.highlightRangeSelectorButton(0<a?0:b.rangeSelector.buttons.length-1)}})},getRangeSelectorInputNavigation:function(){var b=this.chart,a=this.keyCodes;return new l(b,{keyCodeMap:[[[a.tab,a.up,a.down],function(d,e){d=d===a.tab&&e.shiftKey||d===a.up?-1:1;e=b.highlightedInputRangeIx+=d;if(1<e||0>e)return this.response[0<d?"next":"prev"];b.rangeSelector[e?"maxInput":"minInput"].focus();return this.response.success}]],validate:function(){return b.rangeSelector&&
b.rangeSelector.inputGroup&&"hidden"!==b.rangeSelector.inputGroup.element.getAttribute("visibility")&&!1!==b.options.rangeSelector.inputEnabled&&b.rangeSelector.minInput&&b.rangeSelector.maxInput},init:function(a){b.highlightedInputRangeIx=0<a?0:1;b.rangeSelector[b.highlightedInputRangeIx?"maxInput":"minInput"].focus()},terminate:function(){var a=b.rangeSelector;a&&a.maxInput&&a.minInput&&(a.hideInput("max"),a.hideInput("min"))}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),
this.getRangeSelectorInputNavigation()]}});return h});n(f,"modules/accessibility/components/InfoRegionComponent.js",[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"]],function(c,f){var l=c.merge,h=c.pick;c.Chart.prototype.getTypeDescription=function(a){a=a[0];var b=this.series&&this.series[0]||{},e=b.mapTitle;b={numSeries:this.series.length,numPoints:b.points&&b.points.length,chart:this,mapTitle:e};if(!a)return this.langFormat("accessibility.chartTypes.emptyChart",b);if("map"===
a)return e?this.langFormat("accessibility.chartTypes.mapTypeDescription",b):this.langFormat("accessibility.chartTypes.unknownMap",b);if(1<this.types.length)return this.langFormat("accessibility.chartTypes.combinationChart",b);e=this.langFormat("accessibility.seriesTypeDescriptions."+a,{chart:this});var c=this.series&&1===this.series.length?"Single":"Multiple";return(this.langFormat("accessibility.chartTypes."+a+c,b)||this.langFormat("accessibility.chartTypes.default"+c,b))+(e?" "+e:"")};var b=function(a){this.initBase(a);
this.init()};b.prototype=new f;c.extend(b.prototype,{init:function(){var a=this.chart,b=this;this.addEvent(a,"afterGetTable",function(d){a.options.accessibility.enabled&&(b.tableAnchor.setAttribute("aria-expanded",!0),d.html=d.html.replace("<table ",'<table tabindex="0" summary="'+a.langFormat("accessibility.tableSummary",{chart:a})+'"'))});this.addEvent(a,"afterViewData",function(a){setTimeout(function(){var b=a&&a.getElementsByTagName("table")[0];b&&b.focus&&b.focus()},300)})},onChartUpdate:function(){var a=
this.chart,b=a.options.accessibility,e="highcharts-information-region-"+a.index,c=this.screenReaderRegion=this.screenReaderRegion||this.createElement("div"),h=this.tableHeading=this.tableHeading||this.createElement("h6"),g=this.tableAnchor=this.tableAnchor||this.createElement("a"),f=this.chartHeading=this.chartHeading||this.createElement("h6");c.setAttribute("id",e);"all"===b.landmarkVerbosity&&c.setAttribute("role","region");c.setAttribute("aria-label",a.langFormat("accessibility.screenReaderRegionLabel",
{chart:a}));c.innerHTML=b.screenReaderSectionFormatter?b.screenReaderSectionFormatter(a):this.defaultScreenReaderSectionFormatter(a);a.getCSV&&a.options.accessibility.addTableShortcut&&(b="highcharts-data-table-"+a.index,g.innerHTML=a.langFormat("accessibility.viewAsDataTable",{chart:a}),g.href="#"+b,g.setAttribute("tabindex","-1"),g.setAttribute("role","button"),g.setAttribute("aria-expanded",!1),g.onclick=a.options.accessibility.onTableAnchorClick||function(){a.viewData()},h.appendChild(g),c.appendChild(h));
f.innerHTML=a.langFormat("accessibility.chartHeading",{chart:a});f.setAttribute("aria-hidden",!1);a.renderTo.insertBefore(f,a.renderTo.firstChild);a.renderTo.insertBefore(c,a.renderTo.firstChild);this.unhideElementFromScreenReaders(c);l(!0,f.style,this.hiddenStyle);l(!0,c.style,this.hiddenStyle)},defaultScreenReaderSectionFormatter:function(){var a=this.chart,b=a.options,e=a.types,c=this.getAxesDescription();return"<h5>"+(b.accessibility.typeDescription||a.getTypeDescription(e))+"</h5>"+(b.subtitle&&
b.subtitle.text?"<div>"+this.htmlencode(b.subtitle.text)+"</div>":"")+(b.accessibility.description?"<div>"+b.accessibility.description+"</div>":"")+(c.xAxis?"<div>"+c.xAxis+"</div>":"")+(c.yAxis?"<div>"+c.yAxis+"</div>":"")},getAxesDescription:function(){var a=this.chart,b=this,e=a.xAxis,c=1<e.length||e[0]&&h(e[0].options.accessibility&&e[0].options.accessibility.enabled,!a.angular&&a.hasCartesianSeries&&0>a.types.indexOf("map")),f=a.yAxis,g=1<f.length||f[0]&&h(f[0].options.accessibility&&f[0].options.accessibility.enabled,
a.hasCartesianSeries&&0>a.types.indexOf("map")),l={};c&&(l.xAxis=a.langFormat("accessibility.axis.xAxisDescription"+(1<e.length?"Plural":"Singular"),{chart:a,names:a.xAxis.map(function(a){return a.getDescription()}),ranges:a.xAxis.map(function(a){return b.getAxisRangeDescription(a)}),numAxes:e.length}));g&&(l.yAxis=a.langFormat("accessibility.axis.yAxisDescription"+(1<f.length?"Plural":"Singular"),{chart:a,names:a.yAxis.map(function(a){return a.getDescription()}),ranges:a.yAxis.map(function(a){return b.getAxisRangeDescription(a)}),
numAxes:f.length}));return l},getAxisRangeDescription:function(a){var b=this.chart,e=a.options||{};if(e.accessibility&&void 0!==e.accessibility.rangeDescription)return e.accessibility.rangeDescription;if(a.categories)return b.langFormat("accessibility.axis.rangeCategories",{chart:b,axis:a,numCategories:a.dataMax-a.dataMin+1});if(a.isDatetimeAxis&&(0===a.min||0===a.dataMin)){var c={},h="Seconds";c.Seconds=(a.max-a.min)/1E3;c.Minutes=c.Seconds/60;c.Hours=c.Minutes/60;c.Days=c.Hours/24;["Minutes","Hours",
"Days"].forEach(function(a){2<c[a]&&(h=a)});c.value=c[h].toFixed("Seconds"!==h&&"Minutes"!==h?1:0);return b.langFormat("accessibility.axis.timeRange"+h,{chart:b,axis:a,range:c.value.replace(".0","")})}e=b.options.accessibility;return b.langFormat("accessibility.axis.rangeFromTo",{chart:b,axis:a,rangeFrom:a.isDatetimeAxis?b.time.dateFormat(e.axisRangeDateFormat,a.min):a.min,rangeTo:a.isDatetimeAxis?b.time.dateFormat(e.axisRangeDateFormat,a.max):a.max})}});return b});n(f,"modules/accessibility/components/ContainerComponent.js",
[f["parts/Globals.js"],f["modules/accessibility/AccessibilityComponent.js"]],function(c,f){var l=c.win.document,h=function(b){this.initBase(b)};h.prototype=new f;c.extend(h.prototype,{onChartUpdate:function(){var b=this.chart,a=b.options.accessibility,d="highcharts-title-"+b.index,c=b.options.title.text||b.langFormat("accessibility.defaultChartTitle",{chart:b}),h=this.stripTags(b.langFormat("accessibility.svgContainerTitle",{chartTitle:c})),f=this.stripTags(b.langFormat("accessibility.svgContainerLabel",
{chartTitle:c}));if(h.length){var g=this.svgTitleElement=this.svgTitleElement||l.createElementNS("http://www.w3.org/2000/svg","title");g.textContent=h;g.id=d;b.renderTo.insertBefore(g,b.renderTo.firstChild)}b.renderer.box&&f.length&&b.renderer.box.setAttribute("aria-label",f);"disabled"!==a.landmarkVerbosity?b.renderTo.setAttribute("role","region"):b.renderTo.removeAttribute("role");b.renderTo.setAttribute("aria-label",b.langFormat("accessibility.chartContainerLabel",{title:this.stripTags(c),chart:b}));
if(a=b.credits&&b.credits.element)b.credits.textStr&&a.setAttribute("aria-label",this.stripTags(b.langFormat("accessibility.credits",{creditsStr:b.credits.textStr}))),this.unhideElementFromScreenReaders(a)},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0);this.destroyBase()}});return h});n(f,"modules/accessibility/high-contrast-mode.js",[f["parts/Globals.js"]],function(c){var f=c.isMS,l=c.win,h=l.document;return{isHighContrastModeActive:function(){if(l.matchMedia&&f&&/Edge\/\d./i.test(l.navigator.userAgent))return l.matchMedia("(-ms-high-contrast: active)").matches;
if(f&&l.getComputedStyle){var b=h.createElement("div");b.style.backgroundImage="url(#)";h.body.appendChild(b);var a=(b.currentStyle||l.getComputedStyle(b)).backgroundImage;h.body.removeChild(b);return"none"===a}return!1},setHighContrastTheme:function(b){b.highContrastModeActive=!0;var a=b.options.accessibility.highContrastTheme;b.update(a,!1);b.series.forEach(function(b){var d=a.plotOptions[b.type]||{};b.update({color:d.color||"windowText",colors:[d.color||"windowText"],borderColor:d.borderColor||
"window"});b.points.forEach(function(a){a.options&&a.options.color&&a.update({color:d.color||"windowText",borderColor:d.borderColor||"window"},!1)})});b.redraw()}}});n(f,"modules/accessibility/high-contrast-theme.js",[],function(){return{chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:null},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},
lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,
dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},
credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",
inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",
trackBorderColor:"windowText"}}});n(f,"modules/accessibility/options.js",[],function(){return{accessibility:{enabled:!0,pointDescriptionThreshold:200,pointNavigationThreshold:!1,addTableShortcut:!0,axisRangeDateFormat:"%Y-%m-%d %H:%M:%S",describeSingleSeries:!1,landmarkVerbosity:"all",keyboardNavigation:{enabled:!0,skipNullPoints:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:"#335cad",lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","chartMenu","legend"],
wrapAround:!0},announceNewData:{enabled:!1,minAnnounceInterval:5E3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}}});n(f,"modules/accessibility/a11y-i18n.js",[f["parts/Globals.js"]],function(c){function f(c,b){var a=c.indexOf("#each("),d=c.indexOf("#plural("),e=c.indexOf("["),f=c.indexOf("]");if(-1<a){e=c.slice(a).indexOf(")")+a;var h=c.substring(0,a);d=c.substring(e+1);e=c.substring(a+6,e).split(",");a=Number(e[1]);c=
"";if(b=b[e[0]])for(a=isNaN(a)?b.length:a,a=0>a?b.length+a:Math.min(a,b.length),e=0;e<a;++e)c+=h+b[e]+d;return c.length?c:""}if(-1<d){h=c.slice(d).indexOf(")")+d;c=c.substring(d+8,h).split(",");switch(Number(b[c[0]])){case 0:c=l(c[4],c[1]);break;case 1:c=l(c[2],c[1]);break;case 2:c=l(c[3],c[1]);break;default:c=c[1]}c?(b=c,b=b.trim&&b.trim()||b.replace(/^\s+|\s+$/g,"")):b="";return b}return-1<e?(d=c.substring(0,e),c=Number(c.substring(e+1,f)),b=b[d],!isNaN(c)&&b&&(0>c?(h=b[b.length+c],void 0===h&&
(h=b[0])):(h=b[c],void 0===h&&(h=b[b.length-1]))),void 0!==h?h:""):"{"+c+"}"}var l=c.pick;c.i18nFormat=function(h,b,a){var d=function(a,b){a=a.slice(b||0);var c=a.indexOf("{"),d=a.indexOf("}");if(-1<c&&d>c)return{statement:a.substring(c+1,d),begin:b+c+1,end:b+d}},e=[];var k=0;do{var l=d(h,k);k=h.substring(k,l&&l.begin-1);k.length&&e.push({value:k,type:"constant"});l&&e.push({value:l.statement,type:"statement"});k=l&&l.end+1}while(l);e.forEach(function(a){"statement"===a.type&&(a.value=f(a.value,b))});
return c.format(e.reduce(function(a,b){return a+b.value},""),b,a)};c.Chart.prototype.langFormat=function(f,b,a){f=f.split(".");for(var d=this.options.lang,e=0;e<f.length;++e)d=d&&d[f[e]];return"string"===typeof d&&c.i18nFormat(d,b,a)};c.setOptions({lang:{accessibility:{screenReaderRegionLabel:"Chart screen reader information.",defaultChartTitle:"Chart",viewAsDataTable:"View as data table.",chartHeading:"Chart graphic.",chartContainerLabel:"{title}. Highcharts interactive chart.",credits:"Chart credits: {creditsStr}",
svgContainerLabel:"Interactive chart",rangeSelectorMinInput:"Select start date.",rangeSelectorMaxInput:"Select end date.",tableSummary:"Table representation of chart.",mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom",drillUpButton:"{buttonText}",rangeSelectorButton:"Select range {buttonText}",legendLabel:"Toggle series visibility",legendItem:"Toggle visibility of {itemName}",thousandsSep:",",svgContainerTitle:"",svgContainerEnd:"End of interactive chart",announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",
newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",
areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",
waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",
splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",
pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",
xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},
exporting:{chartMenuLabel:"Chart export",menuButtonLabel:"View export menu",exportRegionLabel:"Chart export menu"},series:{summary:{"default":"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",
spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",
barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",
boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",
mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},
description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}"}}}})});n(f,"modules/accessibility/accessibility.js",[f["parts/Globals.js"],f["modules/accessibility/KeyboardNavigationHandler.js"],f["modules/accessibility/AccessibilityComponent.js"],f["modules/accessibility/KeyboardNavigation.js"],f["modules/accessibility/components/LegendComponent.js"],f["modules/accessibility/components/MenuComponent.js"],f["modules/accessibility/components/SeriesComponent.js"],f["modules/accessibility/components/ZoomComponent.js"],
f["modules/accessibility/components/RangeSelectorComponent.js"],f["modules/accessibility/components/InfoRegionComponent.js"],f["modules/accessibility/components/ContainerComponent.js"],f["modules/accessibility/high-contrast-mode.js"],f["modules/accessibility/high-contrast-theme.js"],f["modules/accessibility/options.js"]],function(c,f,l,h,b,a,d,e,k,n,g,m,v,p){function r(a){this.init(a)}var q=c.addEvent,t=c.win.document,x=c.pick,y=c.merge,z=c.extend,w=c.error;y(!0,c.defaultOptions,p,{accessibility:{highContrastTheme:v}});
c.KeyboardNavigationHandler=f;c.AccessibilityComponent=l;c.extend(c.SVGElement.prototype,{addFocusBorder:function(a,b){this.focusBorder&&this.removeFocusBorder();var c=this.getBBox();a=x(a,3);c.x+=this.translateX?this.translateX:0;c.y+=this.translateY?this.translateY:0;this.focusBorder=this.renderer.rect(c.x-a,c.y-a,c.width+2*a,c.height+2*a,b&&b.borderRadius).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup);this.renderer.styledMode||this.focusBorder.attr({stroke:b&&b.stroke,
"stroke-width":b&&b.strokeWidth})},removeFocusBorder:function(){this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});c.Chart.prototype.setFocusToElement=function(a,b){var c=this.options.accessibility.keyboardNavigation.focusBorder;(b=b||a.element)&&b.focus&&(b.hcEvents&&b.hcEvents.focusin||q(b,"focusin",function(){}),b.focus(),c.hideBrowserFocusOutline&&(b.style.outline="none"));c.enabled&&(this.focusElement&&this.focusElement.removeFocusBorder(),a.addFocusBorder(c.margin,{stroke:c.style.color,
strokeWidth:c.style.lineWidth,borderRadius:c.style.borderRadius}),this.focusElement=a)};c.Axis.prototype.getDescription=function(){return this.userOptions&&this.userOptions.accessibility&&this.userOptions.accessibility.description||this.axisTitle&&this.axisTitle.textStr||this.options.id||this.categories&&"categories"||this.isDatetimeAxis&&"Time"||"values"};r.prototype={init:function(c){var f=c.options.accessibility;this.chart=c;if(t.addEventListener&&c.renderer.isSVG){this.copyDeprecatedOptions();
var l=this.components={container:new g(c),infoRegion:new n(c),legend:new b(c),chartMenu:new a(c),rangeSelector:new k(c),series:new d(c),zoom:new e(c)};f.customComponents&&z(this.components,f.customComponents);this.keyboardNavigation=new h(c,l);this.update()}else c.renderTo.setAttribute("aria-hidden",!0)},update:function(){var a=this.components,b=this.chart,c=b.options.accessibility;b.types=this.getChartTypes();Object.keys(a).forEach(function(b){a[b].onChartUpdate()});this.keyboardNavigation.update(c.keyboardNavigation.order);
!b.highContrastModeActive&&m.isHighContrastModeActive(b)&&m.setHighContrastTheme(b)},destroy:function(){var a=this.chart||{},b=this.components;Object.keys(b).forEach(function(a){b[a].destroy()});this.keyboardNavigation&&this.keyboardNavigation.destroy();a.renderTo&&a.renderTo.setAttribute("aria-hidden",!0);a.focusElement&&a.focusElement.removeFocusBorder()},getChartTypes:function(){var a={};this.chart.series.forEach(function(b){a[b.type]=1});return Object.keys(a)},copyDeprecatedOptions:function(){var a=
this.chart,b=function(b,c){w("Highcharts: Deprecated option "+b+" used. Use "+c+" instead.",!1,a)},c={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]},d=a.options.chart||{},e=a.options.accessibility||{};["description","typeDescription"].forEach(function(a){d[a]&&(e[a]=d[a],b("chart."+a,"accessibility."+
a))});a.axes.forEach(function(a){(a=a.options)&&a.description&&(a.accessibility=a.accessibility||{},a.accessibility.description=a.description,b("axis.description","axis.accessibility.description"))});a.series&&a.series.forEach(function(a){Object.keys(c).forEach(function(d){var e=a.options[d];if(void 0!==e){e="skipKeyboardNavigation"===d?!e:e;for(var f=c[d],g=a.options,h,k=0;k<f.length-1;++k)h=f[k],g=g[h]=x(g[h],{});g[f[f.length-1]]=e;b("series."+d,"series."+c[d].join("."))}});a.points&&a.points.forEach(function(a){a.options&&
a.options.description&&(a.options.accessibility=a.options.accessibility||{},a.options.accessibility.description=a.options.description,b("point.description","point.accessibility.description"))})})}};q(c.Chart,"render",function(a){var b=this.accessibility;if(this.a11yDirty&&this.renderTo){delete this.a11yDirty;var c=this.options.accessibility;c&&c.enabled?b?b.update():this.accessibility=b=new r(this):b?(b.destroy&&b.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)}b&&
Object.keys(b.components).forEach(function(c){b.components[c].onChartRender(a)})});q(c.Chart,"update",function(a){if(a=a.options.accessibility)a.customComponents&&(this.options.accessibility.customComponents=a.customComponents,delete a.customComponents),y(!0,this.options.accessibility,a),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility);this.a11yDirty=!0});q(c.Point,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=
!0)});["addSeries","init"].forEach(function(a){q(c.Chart,a,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(a){q(c.Series,a,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(a){q(c.Chart,a,function(){this.accessibility&&this.accessibility.update()})});q(c.Chart,"destroy",function(){this.accessibility&&this.accessibility.destroy()})});n(f,"masters/modules/accessibility.src.js",[],function(){})});
//# sourceMappingURL=accessibility.js.map