/*
 Highcharts JS v7.1.3 (2019-08-14)

 Annotations module

 (c) 2009-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/annotations",["highcharts"],function(t){c(t);c.Highcharts=t;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function t(b,h,c,m){b.hasOwnProperty(h)||(b[h]=m.apply(null,c))}c=c?c._modules:{};t(c,"annotations/eventEmitterMixin.js",[c["parts/Globals.js"],c["parts/Utilities.js"]],function(b,h){var c=h.objectEach,m=b.fireEvent;
return{addEvents:function(){var a=this;b.addEvent(a.graphic.element,"mousedown",function(f){a.onMouseDown(f)});c(a.options.events,function(f,e){var d=function(d){"click"===e&&a.cancelClick||f.call(a,a.chart.pointer.normalize(d),a.target)};if(-1===b.inArray(e,a.nonDOMEvents||[]))a.graphic.on(e,d);else b.addEvent(a,e,d)});a.options.draggable&&(b.addEvent(a,"drag",a.onDrag),a.graphic.renderer.styledMode||a.graphic.css({cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[a.options.draggable]}));a.isUpdating||
m(a,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(a){var f=this,e=f.chart.pointer;a.preventDefault&&a.preventDefault();if(2!==a.button){a=e.normalize(a);var d=a.chartX;var l=a.chartY;f.cancelClick=!1;f.removeDrag=b.addEvent(b.doc,"mousemove",function(a){f.hasDragged=!0;a=e.normalize(a);a.prevChartX=d;a.prevChartY=l;m(f,"drag",a);d=a.chartX;l=a.chartY});f.removeMouseUp=b.addEvent(b.doc,
"mouseup",function(d){f.cancelClick=f.hasDragged;f.hasDragged=!1;m(b.pick(f.target,f),"afterUpdate");f.onMouseUp(d)})}},onMouseUp:function(){var a=this.chart,f=this.target||this,e=a.options.annotations;a=a.annotations.indexOf(f);this.removeDocEvents();e[a]=f.options},onDrag:function(a){if(this.chart.isInsidePlot(a.chartX-this.chart.plotLeft,a.chartY-this.chart.plotTop)){var f=this.mouseMoveToTranslation(a);"x"===this.options.draggable&&(f.y=0);"y"===this.options.draggable&&(f.x=0);this.points.length?
this.translate(f.x,f.y):(this.shapes.forEach(function(a){a.translate(f.x,f.y)}),this.labels.forEach(function(a){a.translate(f.x,f.y)}));this.redraw(!1)}},mouseMoveToRadians:function(a,f,e){var d=a.prevChartY-e,l=a.prevChartX-f;e=a.chartY-e;a=a.chartX-f;this.chart.inverted&&(f=l,l=d,d=f,f=a,a=e,e=f);return Math.atan2(e,a)-Math.atan2(d,l)},mouseMoveToTranslation:function(a){var f=a.chartX-a.prevChartX;a=a.chartY-a.prevChartY;if(this.chart.inverted){var e=a;a=f;f=e}return{x:f,y:a}},mouseMoveToScale:function(a,
f,e){f=(a.chartX-f||1)/(a.prevChartX-f||1);a=(a.chartY-e||1)/(a.prevChartY-e||1);this.chart.inverted&&(e=a,a=f,f=e);return{x:f,y:a}},destroy:function(){this.removeDocEvents();b.removeEvent(this);this.hcEvents=null}}});t(c,"annotations/ControlPoint.js",[c["parts/Globals.js"],c["annotations/eventEmitterMixin.js"]],function(b,h){function c(c,a,f,e){this.chart=c;this.target=a;this.options=f;this.index=b.pick(f.index,e)}b.extend(c.prototype,h);c.prototype.nonDOMEvents=["drag"];c.prototype.setVisibility=
function(b){this.graphic.attr("visibility",b?"visible":"hidden");this.options.visible=b};c.prototype.render=function(){var b=this.chart,a=this.options;this.graphic=b.renderer.symbol(a.symbol,0,0,a.width,a.height).add(b.controlPointsGroup).css(a.style);this.setVisibility(a.visible);this.addEvents()};c.prototype.redraw=function(b){this.graphic[b?"animate":"attr"](this.options.positioner.call(this,this.target))};c.prototype.destroy=function(){h.destroy.call(this);this.graphic&&(this.graphic=this.graphic.destroy());
this.options=this.target=this.chart=null};c.prototype.update=function(c){var a=this.chart,f=this.target,e=this.index;c=b.merge(!0,this.options,c);this.destroy();this.constructor(a,f,c,e);this.render(a.controlPointsGroup);this.redraw()};return c});t(c,"annotations/MockPoint.js",[c["parts/Globals.js"],c["parts/Utilities.js"]],function(b,c){function h(a,f,e){this.series={visible:!0,chart:a,getPlotBox:b.Series.prototype.getPlotBox};this.target=f||null;this.options=e;this.applyOptions(this.getOptions())}
var m=c.defined;h.fromPoint=function(a){return new h(a.series.chart,null,{x:a.x,y:a.y,xAxis:a.series.xAxis,yAxis:a.series.yAxis})};h.pointToPixels=function(a,f){var e=a.series,d=e.chart,l=a.plotX,b=a.plotY;d.inverted&&(a.mock?(l=a.plotY,b=a.plotX):(l=d.plotWidth-a.plotY,b=d.plotHeight-a.plotX));e&&!f&&(a=e.getPlotBox(),l+=a.translateX,b+=a.translateY);return{x:l,y:b}};h.pointToOptions=function(a){return{x:a.x,y:a.y,xAxis:a.series.xAxis,yAxis:a.series.yAxis}};b.extend(h.prototype,{mock:!0,hasDynamicOptions:function(){return"function"===
typeof this.options},getOptions:function(){return this.hasDynamicOptions()?this.options(this.target):this.options},applyOptions:function(a){this.command=a.command;this.setAxis(a,"x");this.setAxis(a,"y");this.refresh()},setAxis:function(a,f){f+="Axis";a=a[f];var e=this.series.chart;this.series[f]=a instanceof b.Axis?a:m(a)?e[f][a]||e.get(a):null},toAnchor:function(){var a=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&(a[0]=this.plotY,a[1]=this.plotX);return a},getLabelConfig:function(){return{x:this.x,
y:this.y,point:this}},isInsidePane:function(){var a=this.plotX,f=this.plotY,e=this.series.xAxis,d=this.series.yAxis,l=!0;e&&(l=m(a)&&0<=a&&a<=e.len);d&&(l=l&&m(f)&&0<=f&&f<=d.len);return l},refresh:function(){var a=this.series,f=a.xAxis;a=a.yAxis;var e=this.getOptions();f?(this.x=e.x,this.plotX=f.toPixels(e.x,!0)):(this.x=null,this.plotX=e.x);a?(this.y=e.y,this.plotY=a.toPixels(e.y,!0)):(this.y=null,this.plotY=e.y);this.isInside=this.isInsidePane()},translate:function(a,f,e,d){this.hasDynamicOptions()||
(this.plotX+=e,this.plotY+=d,this.refreshOptions())},scale:function(a,f,e,d){if(!this.hasDynamicOptions()){var l=this.plotY*d;this.plotX=(1-e)*a+this.plotX*e;this.plotY=(1-d)*f+l;this.refreshOptions()}},rotate:function(a,f,e){if(!this.hasDynamicOptions()){var d=Math.cos(e);e=Math.sin(e);var l=this.plotX,b=this.plotY;l-=a;b-=f;this.plotX=l*d-b*e+a;this.plotY=l*e+b*d+f;this.refreshOptions()}},refreshOptions:function(){var a=this.series,b=a.xAxis;a=a.yAxis;this.x=this.options.x=b?this.options.x=b.toValue(this.plotX,
!0):this.plotX;this.y=this.options.y=a?a.toValue(this.plotY,!0):this.plotY}});return h});t(c,"annotations/controllable/controllableMixin.js",[c["parts/Globals.js"],c["parts/Utilities.js"],c["annotations/ControlPoint.js"],c["annotations/MockPoint.js"]],function(b,c,r,m){var a=c.isObject,f=c.isString,e=c.splat;return{init:function(d,a,e){this.annotation=d;this.chart=d.chart;this.options=a;this.points=[];this.controlPoints=[];this.index=e;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,
arguments)},getPointsOptions:function(){var d=this.options;return d.points||d.point&&e(d.point)},attrsFromOptions:function(d){var a=this.constructor.attrsMap,e={},b,k=this.chart.styledMode;for(b in d){var g=a[b];!g||k&&-1!==["fill","stroke","stroke-width"].indexOf(g)||(e[g]=d[b])}return e},anchor:function(d){var a=d.series.getPlotBox();d=d.mock?d.toAnchor():b.Tooltip.prototype.getAnchor.call({chart:d.series.chart},d);d={x:d[0]+(this.options.x||0),y:d[1]+(this.options.y||0),height:d[2]||0,width:d[3]||
0};return{relativePosition:d,absolutePosition:b.merge(d,{x:d.x+a.translateX,y:d.y+a.translateY})}},point:function(d,e){if(d&&d.series)return d;e&&null!==e.series||(a(d)?e=new m(this.chart,this,d):f(d)?e=this.chart.get(d)||null:"function"===typeof d&&(e=d.call(e,this),e=e.series?e:new m(this.chart,this,d)));return e},linkPoints:function(){var d=this.getPointsOptions(),a=this.points,e=d&&d.length||0,b;for(b=0;b<e;b++){var k=this.point(d[b],a[b]);if(!k){a.length=0;return}k.mock&&k.refresh();a[b]=k}return a},
addControlPoints:function(){var d=this.options.controlPoints;(d||[]).forEach(function(a,e){a=b.merge(this.options.controlPointOptions,a);a.index||(a.index=e);d[e]=a;this.controlPoints.push(new r(this.chart,this,a))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(){this.controlPoints.forEach(function(a){a.render()})},redraw:function(a){this.controlPoints.forEach(function(d){d.redraw(a)})},transform:function(a,e,b,f,k){if(this.chart.inverted){var d=e;e=b;b=d}this.points.forEach(function(d,
p){this.transformPoint(a,e,b,f,k,p)},this)},transformPoint:function(a,e,b,f,k,g){var d=this.points[g];d.mock||(d=this.points[g]=m.fromPoint(d));d[a](e,b,f,k)},translate:function(a,e){this.transform("translate",null,null,a,e)},translatePoint:function(a,e,b){this.transformPoint("translate",null,null,a,e,b)},translateShape:function(a,e){var d=this.annotation.chart,b=this.annotation.userOptions,k=d.annotations.indexOf(this.annotation);d=d.options.annotations[k];this.translatePoint(a,e,0);d[this.collection][this.index].point=
this.options.point;b[this.collection][this.index].point=this.options.point},rotate:function(a,e,b){this.transform("rotate",a,e,b)},scale:function(a,e,b,f){this.transform("scale",a,e,b,f)},setControlPointsVisibility:function(a){this.controlPoints.forEach(function(d){d.setVisibility(a)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());this.controlPoints.forEach(function(a){a.destroy()});this.options=this.controlPoints=this.points=
this.chart=null;this.annotation&&(this.annotation=null)},update:function(a){var e=this.annotation;a=b.merge(!0,this.options,a);var d=this.graphic.parentGroup;this.destroy();this.constructor(e,a);this.render(d);this.redraw()}}});t(c,"annotations/controllable/markerMixin.js",[c["parts/Globals.js"],c["parts/Utilities.js"]],function(b,c){var h=c.defined,m=c.objectEach,a=c.splat,f={arrow:{tagName:"marker",render:!1,id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10,children:[{tagName:"path",d:"M 0 0 L 10 5 L 0 10 Z",
strokeWidth:0}]},"reverse-arrow":{tagName:"marker",render:!1,id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10,children:[{tagName:"path",d:"M 0 5 L 10 0 L 10 10 Z",strokeWidth:0}]}};b.SVGRenderer.prototype.addMarker=function(a,d){var e={id:a},f={stroke:d.color||"none",fill:d.color||"rgba(0, 0, 0, 0.75)"};e.children=d.children.map(function(a){return b.merge(f,a)});d=this.definition(b.merge(!0,{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"},d,e));d.id=a;return d};c=function(a){return function(d){this.attr(a,
"url(#"+d+")")}};c={markerEndSetter:c("marker-end"),markerStartSetter:c("marker-start"),setItemMarkers:function(a){var d=a.options,e=a.chart,f=e.options.defs,c=d.fill,k=h(c)&&"none"!==c?c:d.stroke;["markerStart","markerEnd"].forEach(function(g){var l=d[g],p;if(l){for(p in f){var u=f[p];if(l===u.id&&"marker"===u.tagName){var n=u;break}}n&&(l=a[g]=e.renderer.addMarker((d.id||b.uniqueKey())+"-"+n.id,b.merge(n,{color:k})),a.attr(g,l.attr("id")))}})}};b.SVGRenderer.prototype.definition=function(e){function d(e,
l){var k;a(e).forEach(function(a){var e=f.createElement(a.tagName),p={};m(a,function(a,e){"tagName"!==e&&"children"!==e&&"textContent"!==e&&(p[e]=a)});e.attr(p);e.add(l||f.defs);a.textContent&&e.element.appendChild(b.doc.createTextNode(a.textContent));d(a.children||[],e);k=e});return k}var f=this;return d(e)};b.addEvent(b.Chart,"afterGetContainer",function(){this.options.defs=b.merge(f,this.options.defs||{});m(this.options.defs,function(a){"marker"===a.tagName&&!1!==a.render&&this.renderer.addMarker(a.id,
a)},this)});return c});t(c,"annotations/controllable/ControllablePath.js",[c["parts/Globals.js"],c["annotations/controllable/controllableMixin.js"],c["annotations/controllable/markerMixin.js"]],function(b,c,r){function h(a,e,d){this.init(a,e,d);this.collection="shapes"}var a="rgba(192,192,192,"+(b.svg?.0001:.002)+")";h.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"};b.merge(!0,h.prototype,c,{type:"path",setMarkers:r.setItemMarkers,toD:function(){var a=
this.options.d;if(a)return"function"===typeof a?a.call(this):a;var e=this.points,d=e.length,b=d,c=e[0],h=b&&this.anchor(c).absolutePosition,k=0,g=2;for(a=h&&["M",h.x,h.y];++k<d&&b;)c=e[k],b=c.command||"L",h=this.anchor(c).absolutePosition,"Z"===b?a[++g]=b:(b!==e[k-1].command&&(a[++g]=b),a[++g]=h.x,a[++g]=h.y),b=c.series.visible;return b?this.chart.renderer.crispLine(a,this.graphic.strokeWidth()):null},shouldBeDrawn:function(){return c.shouldBeDrawn.call(this)||!!this.options.d},render:function(f){var e=
this.options,d=this.attrsFromOptions(e);this.graphic=this.annotation.chart.renderer.path(["M",0,0]).attr(d).add(f);e.className&&this.graphic.addClass(e.className);this.tracker=this.annotation.chart.renderer.path(["M",0,0]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(f);this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:a,fill:a,"stroke-width":this.graphic.strokeWidth()+2*e.snap});c.render.call(this);b.extend(this.graphic,{markerStartSetter:r.markerStartSetter,
markerEndSetter:r.markerEndSetter});this.setMarkers(this)},redraw:function(a){var e=this.toD(),d=a?"animate":"attr";e?(this.graphic[d]({d:e}),this.tracker[d]({d:e})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));this.graphic.placed=this.tracker.placed=!!e;c.redraw.call(this,a)}});return h});t(c,"annotations/controllable/ControllableRect.js",[c["parts/Globals.js"],c["annotations/controllable/controllableMixin.js"],c["annotations/controllable/ControllablePath.js"]],
function(b,c,r){function h(a,b,e){this.init(a,b,e);this.collection="shapes"}h.attrsMap=b.merge(r.attrsMap,{width:"width",height:"height"});b.merge(!0,h.prototype,c,{type:"rect",translate:c.translateShape,render:function(a){var b=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(b).add(a);c.render.call(this)},redraw:function(a){var b=this.anchor(this.points[0]).absolutePosition;if(b)this.graphic[a?"animate":"attr"]({x:b.x,y:b.y,width:this.options.width,
height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!b;c.redraw.call(this,a)}});return h});t(c,"annotations/controllable/ControllableCircle.js",[c["parts/Globals.js"],c["annotations/controllable/controllableMixin.js"],c["annotations/controllable/ControllablePath.js"]],function(b,c,r){function h(a,b,e){this.init(a,b,e);this.collection="shapes"}h.attrsMap=b.merge(r.attrsMap,{r:"r"});b.merge(!0,h.prototype,c,{type:"circle",translate:c.translateShape,render:function(a){var b=
this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(b).add(a);c.render.call(this)},redraw:function(a){var b=this.anchor(this.points[0]).absolutePosition;if(b)this.graphic[a?"animate":"attr"]({x:b.x,y:b.y,r:this.options.r});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!b;c.redraw.call(this,a)},setRadius:function(a){this.options.r=a}});return h});t(c,"annotations/controllable/ControllableLabel.js",[c["parts/Globals.js"],c["parts/Utilities.js"],
c["annotations/controllable/controllableMixin.js"],c["annotations/MockPoint.js"]],function(b,c,r,m){function a(a,d,b){this.init(a,d,b);this.collection="labels"}var f=c.isNumber;a.shapesWithoutBackground=["connector"];a.alignedPosition=function(a,d){var e=a.align,b=a.verticalAlign,c=(d.x||0)+(a.x||0),k=(d.y||0)+(a.y||0),g,f;"right"===e?g=1:"center"===e&&(g=2);g&&(c+=(d.width-(a.width||0))/g);"bottom"===b?f=1:"middle"===b&&(f=2);f&&(k+=(d.height-(a.height||0))/f);return{x:Math.round(c),y:Math.round(k)}};
a.justifiedOptions=function(a,d,b,c){var e=b.align,k=b.verticalAlign,g=d.box?0:d.padding||0,f=d.getBBox();d={align:e,verticalAlign:k,x:b.x,y:b.y,width:d.width,height:d.height};b=c.x-a.plotLeft;var p=c.y-a.plotTop;c=b+g;0>c&&("right"===e?d.align="left":d.x=-c);c=b+f.width-g;c>a.plotWidth&&("left"===e?d.align="right":d.x=a.plotWidth-c);c=p+g;0>c&&("bottom"===k?d.verticalAlign="top":d.y=-c);c=p+f.height-g;c>a.plotHeight&&("top"===k?d.verticalAlign="bottom":d.y=a.plotHeight-c);return d};a.attrsMap={backgroundColor:"fill",
borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};b.merge(!0,a.prototype,r,{translatePoint:function(a,b){r.translatePoint.call(this,a,b,0)},translate:function(a,b){var d=this.annotation.chart,e=this.annotation.userOptions,c=d.annotations.indexOf(this.annotation);c=d.options.annotations[c];d.inverted&&(d=a,a=b,b=d);this.options.x+=a;this.options.y+=b;c[this.collection][this.index].x=this.options.x;c[this.collection][this.index].y=this.options.y;e[this.collection][this.index].x=
this.options.x;e[this.collection][this.index].y=this.options.y},render:function(b){var d=this.options,e=this.attrsFromOptions(d),c=d.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,d.shape,null,null,d.useHTML,null,"annotation-label").attr(e).add(b);this.annotation.chart.styledMode||("contrast"===c.color&&(c.color=this.annotation.chart.renderer.getContrast(-1<a.shapesWithoutBackground.indexOf(d.shape)?"#FFFFFF":d.backgroundColor)),this.graphic.css(d.style).shadow(d.shadow));d.className&&
this.graphic.addClass(d.className);this.graphic.labelrank=d.labelrank;r.render.call(this)},redraw:function(a){var d=this.options,e=this.text||d.format||d.text,c=this.graphic,f=this.points[0];c.attr({text:e?b.format(e,f.getLabelConfig(),this.annotation.chart.time):d.formatter.call(f,this)});d=this.anchor(f);(e=this.position(d))?(c.alignAttr=e,e.anchorX=d.absolutePosition.x,e.anchorY=d.absolutePosition.y,c[a?"animate":"attr"](e)):c.attr({x:0,y:-9999});c.placed=!!e;r.redraw.call(this,a)},anchor:function(){var a=
r.anchor.apply(this,arguments),b=this.options.x||0,c=this.options.y||0;a.absolutePosition.x-=b;a.absolutePosition.y-=c;a.relativePosition.x-=b;a.relativePosition.y-=c;return a},position:function(e){var d=this.graphic,c=this.annotation.chart,f=this.points[0],h=this.options,k=e.absolutePosition,g=e.relativePosition;if(e=f.series.visible&&m.prototype.isInsidePane.call(f)){if(h.distance)var q=b.Tooltip.prototype.getPosition.call({chart:c,distance:b.pick(h.distance,16)},d.width,d.height,{plotX:g.x,plotY:g.y,
negative:f.negative,ttBelow:f.ttBelow,h:g.height||g.width});else h.positioner?q=h.positioner.call(this):(f={x:k.x,y:k.y,width:0,height:0},q=a.alignedPosition(b.extend(h,{width:d.width,height:d.height}),f),"justify"===this.options.overflow&&(q=a.alignedPosition(a.justifiedOptions(c,d,h,q),f)));h.crop&&(h=q.x-c.plotLeft,f=q.y-c.plotTop,e=c.isInsidePlot(h,f)&&c.isInsidePlot(h+d.width,f+d.height))}return e?q:null}});b.SVGRenderer.prototype.symbols.connector=function(a,b,c,h,m){var d=m&&m.anchorX;m=m&&
m.anchorY;var e=c/2;if(f(d)&&f(m)){var q=["M",d,m];var p=b-m;0>p&&(p=-h-p);p<c&&(e=d<a+c/2?p:c-p);m>b+h?q.push("L",a+e,b+h):m<b?q.push("L",a+e,b):d<a?q.push("L",a,b+h/2):d>a+c&&q.push("L",a+c,b+h/2)}return q||[]};return a});t(c,"annotations/controllable/ControllableImage.js",[c["parts/Globals.js"],c["annotations/controllable/controllableMixin.js"],c["annotations/controllable/ControllableLabel.js"]],function(b,c,r){function h(a,b,e){this.init(a,b,e);this.collection="shapes"}h.attrsMap={width:"width",
height:"height",zIndex:"zIndex"};b.merge(!0,h.prototype,c,{type:"image",translate:c.translateShape,render:function(a){var b=this.attrsFromOptions(this.options),e=this.options;this.graphic=this.annotation.chart.renderer.image(e.src,0,-9E9,e.width,e.height).attr(b).add(a);this.graphic.width=e.width;this.graphic.height=e.height;c.render.call(this)},redraw:function(a){var b=this.anchor(this.points[0]);if(b=r.prototype.position.call(this,b))this.graphic[a?"animate":"attr"]({x:b.x,y:b.y});else this.graphic.attr({x:0,
y:-9E9});this.graphic.placed=!!b;c.redraw.call(this,a)}});return h});t(c,"annotations/annotations.src.js",[c["parts/Globals.js"],c["parts/Utilities.js"],c["annotations/controllable/controllableMixin.js"],c["annotations/controllable/ControllableRect.js"],c["annotations/controllable/ControllableCircle.js"],c["annotations/controllable/ControllablePath.js"],c["annotations/controllable/ControllableImage.js"],c["annotations/controllable/ControllableLabel.js"],c["annotations/eventEmitterMixin.js"],c["annotations/MockPoint.js"],
c["annotations/ControlPoint.js"]],function(b,c,r,m,a,f,e,d,l,t,v){var k=c.defined,g=c.erase,q=c.splat,p=b.merge,u=b.addEvent,n=b.fireEvent,x=b.find,y=b.pick,h=b.reduce,z=b.destroyObjectProperties;c=b.Chart.prototype;var w=b.Annotation=function(a,b){this.chart=a;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=b;this.userOptions=p(!0,{},b);var d=this.getLabelsAndShapesOptions(this.userOptions,b);this.userOptions.labels=d.labels;this.userOptions.shapes=
d.shapes;this.init(a,b)};p(!0,w.prototype,r,l,{nonDOMEvents:["add","afterUpdate","remove"],defaultOptions:{visible:!0,draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:"black",borderRadius:3,borderWidth:1,className:"",crop:!1,formatter:function(){return k(this.y)?this.y:"Annotation label"},overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",
x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:"black","stroke-width":2,fill:"white"},visible:!1,events:{}},events:{},zIndex:6},init:function(){this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.addClipPaths();this.setLabelCollector()},getLabelsAndShapesOptions:function(a,b){var d={};["labels","shapes"].forEach(function(c){a[c]&&(d[c]=q(b[c]).map(function(b,
d){return p(a[c][d],b)}))});return d},addShapes:function(){(this.options.shapes||[]).forEach(this.initShape,this)},addLabels:function(){(this.options.labels||[]).forEach(this.initLabel,this)},addClipPaths:function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},setClipAxes:function(){var a=this.chart.xAxis,b=this.chart.yAxis,d=h((this.options.labels||[]).concat(this.options.shapes||[]),function(d,c){return[a[c&&c.point&&c.point.xAxis]||
d[0],b[c&&c.point&&c.point.yAxis]||d[1]]},[]);this.clipXAxis=d[0];this.clipYAxis=d[1]},getClipBox:function(){return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},setLabelCollector:function(){var a=this;a.labelCollector=function(){return a.labels.reduce(function(a,b){b.options.allowOverlap||a.push(b.graphic);return a},[])};a.chart.labelCollectors.push(a.labelCollector)},setOptions:function(a){this.options=p(this.defaultOptions,a)},redraw:function(a){this.linkPoints();
this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);r.redraw.call(this,a)},redrawItems:function(a,b){for(var d=a.length;d--;)this.redrawItem(a[d],b)},render:function(){var a=this.chart.renderer;this.graphic=a.g("annotation").attr({zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=a.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip);
this.labelsGroup=a.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.clipRect&&this.graphic.clip(this.clipRect);this.addEvents();r.render.call(this)},setVisibility:function(a){var b=this.options;a=y(a,!b.visible);this.graphic.attr("visibility",a?"visible":"hidden");a||this.setControlPointsVisibility(!1);b.visible=a},setControlPointsVisibility:function(a){var b=function(b){b.setControlPointsVisibility(a)};r.setControlPointsVisibility.call(this,a);this.shapes.forEach(b);
this.labels.forEach(b)},destroy:function(){var a=this.chart,b=function(a){a.destroy()};this.labels.forEach(b);this.shapes.forEach(b);this.clipYAxis=this.clipXAxis=null;g(a.labelCollectors,this.labelCollector);l.destroy.call(this);r.destroy.call(this);z(this,a)},remove:function(){return this.chart.removeAnnotation(this)},update:function(a){var d=this.chart,c=this.getLabelsAndShapesOptions(this.userOptions,a),e=d.annotations.indexOf(this);a=b.merge(!0,this.userOptions,a);a.labels=c.labels;a.shapes=
c.shapes;this.destroy();this.constructor(d,a);d.options.annotations[e]=a;this.isUpdating=!0;this.redraw();this.isUpdating=!1;n(this,"afterUpdate")},initShape:function(a,b){a=p(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},a);b=new w.shapesMap[a.type](this,a,b);b.itemType="shape";this.shapes.push(b);return b},initLabel:function(a,b){a=p(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},a);b=new d(this,a,b);b.itemType="label";this.labels.push(b);
return b},redrawItem:function(a,d){a.linkPoints();a.shouldBeDrawn()?(a.graphic||this.renderItem(a),a.redraw(b.pick(d,!0)&&a.graphic.placed),a.points.length&&this.adjustVisibility(a)):this.destroyItem(a)},adjustVisibility:function(a){var b=!1,d=a.graphic;a.points.forEach(function(a){!1!==a.series.visible&&!1!==a.visible&&(b=!0)});b?"hidden"===d.visibility&&d.show():d.hide()},destroyItem:function(a){g(this[a.itemType+"s"],a);a.destroy()},renderItem:function(a){a.render("label"===a.itemType?this.labelsGroup:
this.shapesGroup)}});w.shapesMap={rect:m,circle:a,path:f,image:e};w.types={};w.MockPoint=t;w.ControlPoint=v;b.extendAnnotation=function(a,b,d,c){b=b||w;p(!0,a.prototype,b.prototype,d);a.prototype.defaultOptions=p(a.prototype.defaultOptions,c||{})};b.extend(c,{initAnnotation:function(a){var d=w.types[a.type]||w;a=b.merge(d.prototype.defaultOptions,a);d=new d(this,a);this.annotations.push(d);return d},addAnnotation:function(a,b){a=this.initAnnotation(a);this.options.annotations.push(a.options);y(b,
!0)&&a.redraw();return a},removeAnnotation:function(a){var b=this.annotations,d="annotations"===a.coll?a:x(b,function(b){return b.options.id===a});d&&(n(d,"remove"),g(this.options.annotations,d.options),g(b,d),d.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);this.annotations.forEach(function(a){a.redraw()})}});c.collectionsWithUpdate.push("annotations");c.collectionsWithInit.annotations=[c.addAnnotation];c.callbacks.push(function(a){a.annotations=[];a.options.annotations||
(a.options.annotations=[]);a.plotBoxClip=this.renderer.clipRect(this.plotBox);a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(b,d){b=a.initAnnotation(b);a.options.annotations[d]=b.options});a.drawAnnotations();u(a,"redraw",a.drawAnnotations);u(a,"destroy",function(){a.plotBoxClip.destroy();a.controlPointsGroup.destroy()})})});t(c,"mixins/navigation.js",[],function(){return{initUpdate:function(b){b.navigation||(b.navigation=
{updates:[],update:function(b,c){this.updates.forEach(function(h){h.update.call(h.context,b,c)})}})},addUpdate:function(b,c){c.navigation||this.initUpdate(c);c.navigation.updates.push({update:b,context:c})}}});t(c,"annotations/navigationBindings.js",[c["parts/Globals.js"],c["parts/Utilities.js"],c["mixins/navigation.js"]],function(b,c,r){function h(a){var d=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click;b.merge(!0,a.prototype.defaultOptions.events,{click:function(a){var b=
this,c=b.chart.navigationBindings,e=c.activeAnnotation;d&&d.click.call(b,a);e!==b?(c.deselectAnnotation(),c.activeAnnotation=b,b.setControlPointsVisibility(!0),q(c,"showPopup",{annotation:b,formType:"annotation-toolbar",options:c.annotationToFields(b),onSubmit:function(a){var d={};"remove"===a.actionType?(c.activeAnnotation=!1,c.chart.removeAnnotation(b)):(c.fieldsToOptions(a.fields,d),c.deselectAnnotation(),a=d.typeOptions,"measure"===b.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,
a.crosshairX.enabled=0!==a.crosshairX.strokeWidth),b.update(d))}})):(c.deselectAnnotation(),q(c,"closePopup"));a.activeAnnotation=!0}})}var a=c.isArray,f=c.isNumber,e=c.isObject,d=c.objectEach,l=b.doc,t=b.win,v=b.addEvent,k=b.pick,g=b.merge;c=b.extend;var q=b.fireEvent;b.NavigationBindings=function(a,b){this.chart=a;this.options=b;this.eventsToUnbind=[];this.container=l.getElementsByClassName(this.options.bindingsClassName)};b.NavigationBindings.annotationsEditable={nestedOptions:{labelOptions:["style",
"format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],
label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[]};b.NavigationBindings.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]};c(b.NavigationBindings.prototype,{initEvents:function(){var a=this,c=a.chart,e=a.container,g=a.options;a.boundClassNames={};d(g.bindings,function(b){a.boundClassNames[b.className]=b});[].forEach.call(e,function(b){a.eventsToUnbind.push(v(b,
"click",function(b){var d=a.getButtonEvents(e,b);d&&a.bindingsButtonClick(d.button,d.events,b)}))});d(g.events||{},function(d,c){b.isFunction(d)&&a.eventsToUnbind.push(v(a,c,d))});a.eventsToUnbind.push(v(c.container,"click",function(b){!c.cancelClick&&c.isInsidePlot(b.chartX-c.plotLeft,b.chartY-c.plotTop)&&a.bindingsChartClick(this,b)}));a.eventsToUnbind.push(v(c.container,"mousemove",function(b){a.bindingsContainerMouseMove(this,b)}))},initUpdate:function(){var a=this;r.addUpdate(function(b){a.update(b)},
this.chart)},bindingsButtonClick:function(a,b,d){var c=this.chart;this.selectedButtonElement&&(q(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&c.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));this.selectedButton=b;this.selectedButtonElement=a;q(this,"selectButton",{button:a});b.init&&b.init.call(this,a,d);(b.start||b.steps)&&c.renderer.boxWrapper.addClass("highcharts-draw-mode")},
bindingsChartClick:function(a,b){a=this.selectedButton;var d=this.chart.renderer.boxWrapper,c;if(c=this.activeAnnotation&&!b.activeAnnotation&&b.target.parentNode){a:{c=b.target;var e=t.Element.prototype,g=e.matches||e.msMatchesSelector||e.webkitMatchesSelector,k=null;if(e.closest)k=e.closest.call(c,".highcharts-popup");else{do{if(g.call(c,".highcharts-popup"))break a;c=c.parentElement||c.parentNode}while(null!==c&&1===c.nodeType)}c=k}c=!c}c&&(q(this,"closePopup"),this.deselectAnnotation());a&&a.start&&
(this.nextEvent?(this.nextEvent(b,this.currentUserDetails),this.steps&&(this.stepIndex++,a.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=a.steps[this.stepIndex]:(q(this,"deselectButton",{button:this.selectedButtonElement}),d.removeClass("highcharts-draw-mode"),a.end&&a.end.call(this,b,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=a.start.call(this,b),a.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=
a.steps[this.stepIndex]):(q(this,"deselectButton",{button:this.selectedButtonElement}),d.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,a.end&&a.end.call(this,b,this.currentUserDetails))))},bindingsContainerMouseMove:function(a,b){this.mouseMoveEvent&&this.mouseMoveEvent(b,this.currentUserDetails)},fieldsToOptions:function(a,b){d(a,function(a,c){var d=parseFloat(a),e=c.split("."),g=b,n=e.length-1;!f(d)||a.match(/px/g)||c.match(/format/g)||(a=d);""!==a&&"undefined"!==a&&
e.forEach(function(b,c){var d=k(e[c+1],"");n===c?g[b]=a:(g[b]||(g[b]=d.match(/\d/g)?[]:{}),g=g[b])})});return b},deselectAnnotation:function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},annotationToFields:function(c){function g(k,n,f,u){if(f&&-1===l.indexOf(n)&&(0<=(f.indexOf&&f.indexOf(n))||f[n]||!0===f))if(a(k))u[n]=[],k.forEach(function(a,b){e(a)?(u[n][b]={},d(a,function(a,c){g(a,c,p[n],u[n][b])})):g(a,0,p[n],u[n])});else if(e(k)){var x=
{};a(u)?(u.push(x),x[n]={},x=x[n]):u[n]=x;d(k,function(a,b){g(a,b,0===n?f:p[n],x)})}else"format"===n?u[n]=[b.format(k,c.labels[0].points[0]).toString(),"text"]:a(u)?u.push([k,q(k)]):u[n]=[k,q(k)]}var n=c.options,f=b.NavigationBindings.annotationsEditable,p=f.nestedOptions,q=this.utils.getFieldType,h=k(n.type,n.shapes&&n.shapes[0]&&n.shapes[0].type,n.labels&&n.labels[0]&&n.labels[0].itemType,"label"),l=b.NavigationBindings.annotationsNonEditable[n.langKey]||[],m={langKey:n.langKey,type:h};d(n,function(a,
b){"typeOptions"===b?(m[b]={},d(n[b],function(a,c){g(a,c,p,m[b],!0)})):g(a,b,f[h],m)});return m},getClickedClassNames:function(a,c){var d=c.target;c=[];for(var e;d&&((e=b.attr(d,"class"))&&(c=c.concat(e.split(" ").map(function(a){return[a,d]}))),d=d.parentNode,d!==a););return c},getButtonEvents:function(a,b){var c=this,d;this.getClickedClassNames(a,b).forEach(function(a){c.boundClassNames[a[0]]&&!d&&(d={events:c.boundClassNames[a[0]],button:a[1]})});return d},update:function(a){this.options=g(!0,
this.options,a);this.removeEvents();this.initEvents()},removeEvents:function(){this.eventsToUnbind.forEach(function(a){a()})},destroy:function(){this.removeEvents()},utils:{updateRectSize:function(a,b){var c=b.chart,d=b.options.typeOptions,e=c.pointer.getCoordinates(a);a=e.xAxis[0].value-d.point.x;d=d.point.y-e.yAxis[0].value;b.update({typeOptions:{background:{width:c.inverted?d:a,height:c.inverted?a:d}}})},getFieldType:function(a){return{string:"text",number:"number","boolean":"checkbox"}[typeof a]}}});
b.Chart.prototype.initNavigationBindings=function(){var a=this.options;a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new b.NavigationBindings(this,a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())};v(b.Chart,"load",function(){this.initNavigationBindings()});v(b.Chart,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});v(b.NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});v(b.Annotation,
"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});b.Annotation&&(h(b.Annotation),d(b.Annotation.types,function(a){h(a)}));b.setOptions({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",
backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var c=this.chart.options.navigation;return this.chart.addAnnotation(g({langKey:"circle",
shapes:[{type:"circle",point:{xAxis:0,yAxis:0,x:a.xAxis[0].value,y:a.yAxis[0].value},r:5,controlPoints:[{positioner:function(a){var c=b.Annotation.MockPoint.pointToPixels(a.points[0]);a=a.options.r;return{x:c.x+a*Math.cos(Math.PI/4)-this.graphic.width/2,y:c.y+a*Math.sin(Math.PI/4)-this.graphic.height/2}},events:{drag:function(a,b){var c=b.annotation;a=this.mouseMoveToTranslation(a);b.setRadius(Math.max(b.options.r+a.y/Math.sin(Math.PI/4),5));c.options.shapes[0]=c.userOptions.shapes[0]=b.options;b.redraw(!1)}}}]}]},
c.annotationsOptions,c.bindings.circleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].point,d=this.chart.xAxis[0].toPixels(c.x);c=this.chart.yAxis[0].toPixels(c.y);var e=this.chart.inverted;b.update({shapes:[{r:Math.max(Math.sqrt(Math.pow(e?c-a.chartX:d-a.chartX,2)+Math.pow(e?d-a.chartY:c-a.chartY,2)),5)}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=this.chart.options.navigation;
var d=c.xAxis[0].value;c=c.yAxis[0].value;return this.chart.addAnnotation(g({langKey:"rectangle",shapes:[{type:"path",points:[{xAxis:0,yAxis:0,x:d,y:c},{xAxis:0,yAxis:0,x:d,y:c},{xAxis:0,yAxis:0,x:d,y:c},{xAxis:0,yAxis:0,x:d,y:c}]}],controlPoints:[{positioner:function(a){a=b.Annotation.MockPoint.pointToPixels(a.shapes[0].points[2]);return{x:a.x-4,y:a.y-4}},events:{drag:function(a,b){var c=this.chart.pointer.getCoordinates(a);a=c.xAxis[0].value;c=c.yAxis[0].value;var d=b.options.shapes[0].points;d[1].x=
a;d[2].x=a;d[2].y=c;d[3].y=c;b.options.shapes[0].points=d;b.redraw(!1)}}}]},a.annotationsOptions,a.bindings.rectangleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].points,d=this.chart.pointer.getCoordinates(a);a=d.xAxis[0].value;d=d.yAxis[0].value;c[1].x=a;c[2].x=a;c[2].y=d;c[3].y=d;b.update({shapes:[{points:c}]})}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var c=this.chart.options.navigation;
return this.chart.addAnnotation(g({langKey:"label",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:0,yAxis:0,x:a.xAxis[0].value,y:a.yAxis[0].value},overflow:"none",crop:!0,controlPoints:[{symbol:"triangle-down",positioner:function(a){if(!a.graphic.placed)return{x:0,y:-9E7};a=b.Annotation.MockPoint.pointToPixels(a.points[0]);return{x:a.x-this.graphic.width/2,y:a.y-this.graphic.height/2}},events:{drag:function(a,b){a=this.mouseMoveToTranslation(a);b.translatePoint(a.x,a.y);b.annotation.labels[0].options=
b.options;b.redraw(!1)}}},{symbol:"square",positioner:function(a){return a.graphic.placed?{x:a.graphic.alignAttr.x-this.graphic.width/2,y:a.graphic.alignAttr.y-this.graphic.height/2}:{x:0,y:-9E7}},events:{drag:function(a,b){a=this.mouseMoveToTranslation(a);b.translate(a.x,a.y);b.annotation.labels[0].options=b.options;b.redraw(!1)}}}]}]},c.annotationsOptions,c.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{}}})});t(c,"annotations/popup.js",[c["parts/Globals.js"],c["parts/Utilities.js"]],
function(b,c){var h=c.defined,m=c.isArray,a=c.isObject,f=c.isString,e=c.objectEach,d=b.addEvent,l=b.createElement,t=b.pick;c=b.wrap;var v=/\d/g;c(b.Pointer.prototype,"onContainerMouseDown",function(a,b){var c=b.target&&b.target.className;f(c)&&0<=c.indexOf("highcharts-popup-field")||a.apply(this,Array.prototype.slice.call(arguments,1))});b.Popup=function(a,b){this.init(a,b)};b.Popup.prototype={init:function(a,b){this.container=l("div",{className:"highcharts-popup"},null,a);this.lang=this.getLangpack();
this.iconsURL=b;this.addCloseBtn()},addCloseBtn:function(){var a=this;var b=l("div",{className:"highcharts-popup-close"},null,this.container);b.style["background-image"]="url("+this.iconsURL+"close.svg)";["click","touchstart"].forEach(function(c){d(b,c,function(){a.closePopup()})})},addColsContainer:function(a){var b=l("div",{className:"highcharts-popup-lhs-col"},null,a);a=l("div",{className:"highcharts-popup-rhs-col"},null,a);l("div",{className:"highcharts-popup-rhs-col-wrapper"},null,a);return{lhsCol:b,
rhsCol:a}},addInput:function(a,b,c,d){var e=a.split(".");e=e[e.length-1];var g=this.lang;b="highcharts-"+b+"-"+e;b.match(v)||l("label",{innerHTML:g[e]||e,htmlFor:b},null,c);l("input",{name:b,value:d[0],type:d[1],className:"highcharts-popup-field"},null,c).setAttribute("highcharts-data-name",a)},addButton:function(a,b,c,e,f){var g=this,k=this.closePopup,q=this.getFields;var p=l("button",{innerHTML:b},null,a);["click","touchstart"].forEach(function(a){d(p,a,function(){k.call(g);return e(q(f,c))})});
return p},getFields:function(a,b){var c=a.querySelectorAll("input"),d=a.querySelectorAll("#highcharts-select-series > option:checked")[0];a=a.querySelectorAll("#highcharts-select-volume > option:checked")[0];var e,g;var f={actionType:b,linkedTo:d&&d.getAttribute("value"),fields:{}};[].forEach.call(c,function(a){g=a.getAttribute("highcharts-data-name");(e=a.getAttribute("highcharts-data-series-id"))?f.seriesId=a.value:g?f.fields[g]=a.value:f.type=a.value});a&&(f.fields["params.volumeSeriesID"]=a.getAttribute("value"));
return f},showPopup:function(){var a=this.container,b=a.querySelectorAll(".highcharts-popup-close")[0];a.innerHTML="";0<=a.className.indexOf("highcharts-annotation-toolbar")&&(a.classList.remove("highcharts-annotation-toolbar"),a.removeAttribute("style"));a.appendChild(b);a.style.display="block"},closePopup:function(){this.popup.container.style.display="none"},showForm:function(a,b,c,d){this.popup=b.navigationBindings.popup;this.showPopup();"indicators"===a&&this.indicators.addForm.call(this,b,c,
d);"annotation-toolbar"===a&&this.annotations.addToolbar.call(this,b,c,d);"annotation-edit"===a&&this.annotations.addForm.call(this,b,c,d);"flag"===a&&this.annotations.addForm.call(this,b,c,d,!0)},getLangpack:function(){return b.getOptions().lang.navigation.popup},annotations:{addToolbar:function(a,b,c){var d=this,e=this.lang,f=this.popup.container,g=this.showForm;-1===f.className.indexOf("highcharts-annotation-toolbar")&&(f.className+=" highcharts-annotation-toolbar");f.style.top=a.plotTop+10+"px";
l("span",{innerHTML:t(e[b.langKey]||b.langKey,b.shapes&&b.shapes[0].type)},null,f);var k=this.addButton(f,e.removeButton||"remove","remove",c,f);k.className+=" highcharts-annotation-remove-button";k.style["background-image"]="url("+this.iconsURL+"destroy.svg)";k=this.addButton(f,e.editButton||"edit","edit",function(){g.call(d,"annotation-edit",a,b,c)},f);k.className+=" highcharts-annotation-edit-button";k.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(a,b,c,d){var e=
this.popup.container,f=this.lang;l("h2",{innerHTML:f[b.langKey]||b.langKey,className:"highcharts-popup-main-title"},null,e);var g=l("div",{className:"highcharts-popup-lhs-col highcharts-popup-lhs-full"},null,e);var k=l("div",{className:"highcharts-popup-bottom-row"},null,e);this.annotations.addFormFields.call(this,g,a,"",b,[],!0);this.addButton(k,d?f.addButton||"add":f.saveButton||"save",d?"add":"save",c,e)},addFormFields:function(b,c,d,f,h,n){var g=this,k=this.annotations.addFormFields,q=this.addInput,
p=this.lang,u,r;e(f,function(e,f){u=""!==d?d+"."+f:f;a(e)&&(!m(e)||m(e)&&a(e[0])?(r=p[f]||f,r.match(v)||h.push([!0,r,b]),k.call(g,b,c,u,e,h,!1)):h.push([g,u,"annotation",b,e]))});n&&(h=h.sort(function(a){return a[1].match(/format/g)?-1:1}),h.forEach(function(a){!0===a[0]?l("span",{className:"highcharts-annotation-title",innerHTML:a[1]},null,a[2]):q.apply(a[0],a.splice(1))}))}},indicators:{addForm:function(a,b,c){var d=this.indicators,e=this.lang;this.tabs.init.call(this,a);b=this.popup.container.querySelectorAll(".highcharts-tab-item-content");
this.addColsContainer(b[0]);d.addIndicatorList.call(this,a,b[0],"add");var f=b[0].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.addButton||"add","add",c,f);this.addColsContainer(b[1]);d.addIndicatorList.call(this,a,b[1],"edit");f=b[1].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.saveButton||"save","edit",c,f);this.addButton(f,e.removeButton||"remove","remove",c,f)},addIndicatorList:function(a,b,c){var f=this,g=b.querySelectorAll(".highcharts-popup-lhs-col")[0];
b=b.querySelectorAll(".highcharts-popup-rhs-col")[0];var k="edit"===c,h=k?a.series:a.options.plotOptions,q=this.indicators.addFormFields,m;var r=l("ul",{className:"highcharts-indicator-list"},null,g);var t=b.querySelectorAll(".highcharts-popup-rhs-col-wrapper")[0];e(h,function(b,c){var e=b.options;if(b.params||e&&e.params){var g=f.indicators.getNameType(b,c),p=g.type;m=l("li",{className:"highcharts-indicator-list",innerHTML:g.name},null,r);["click","touchstart"].forEach(function(c){d(m,c,function(){q.call(f,
a,k?b:h[p],g.type,t);k&&b.options&&l("input",{type:"hidden",name:"highcharts-id-"+p,value:b.options.id},null,t).setAttribute("highcharts-data-series-id",b.options.id)})})}});0<r.childNodes.length&&r.childNodes[0].click()},getNameType:function(a,c){var d=a.options,e=b.seriesTypes;e=e[c]&&e[c].prototype.nameBase||c.toUpperCase();d&&d.type&&(c=a.options.type,e=a.name);return{name:e,type:c}},listAllSeries:function(a,b,c,d,e){a="highcharts-"+b+"-type-"+a;var f;l("label",{innerHTML:this.lang[b]||b,htmlFor:a},
null,d);var g=l("select",{name:a,className:"highcharts-popup-field"},null,d);g.setAttribute("id","highcharts-select-"+b);c.series.forEach(function(a){f=a.options;!f.params&&f.id&&"highcharts-navigator-series"!==f.id&&l("option",{innerHTML:f.name||f.id,value:f.id},null,g)});h(e)&&(g.value=e)},addFormFields:function(a,b,c,d){var e=b.params||b.options.params,f=this.indicators.getNameType;d.innerHTML="";l("h3",{className:"highcharts-indicator-title",innerHTML:f(b,c).name},null,d);l("input",{type:"hidden",
name:"highcharts-type-"+c,value:c},null,d);this.indicators.listAllSeries.call(this,c,"series",a,d,b.linkedParent&&e.volumeSeriesID);e.volumeSeriesID&&this.indicators.listAllSeries.call(this,c,"volume",a,d,b.linkedParent&&b.linkedParent.options.id);this.indicators.addParamInputs.call(this,a,"params",e,c,d)},addParamInputs:function(b,c,d,f,h){var g=this,k=this.indicators.addParamInputs,l=this.addInput,q;e(d,function(d,e){q=c+"."+e;a(d)?k.call(g,b,q,d,f,h):"params.volumeSeriesID"!==q&&l.call(g,q,f,h,
[d,"text"])})},getAmount:function(){var a=0;e(this.series,function(b){var c=b.options;(b.params||c&&c.params)&&a++});return a}},tabs:{init:function(a){var b=this.tabs;a=this.indicators.getAmount.call(a);var c=b.addMenuItem.call(this,"add");b.addMenuItem.call(this,"edit",a);b.addContentItem.call(this,"add");b.addContentItem.call(this,"edit");b.switchTabs.call(this,a);b.selectTab.call(this,c,0)},addMenuItem:function(a,b){var c=this.popup.container,d="highcharts-tab-item",e=this.lang;0===b&&(d+=" highcharts-tab-disabled");
b=l("span",{innerHTML:e[a+"Button"]||a,className:d},null,c);b.setAttribute("highcharts-data-tab-type",a);return b},addContentItem:function(){return l("div",{className:"highcharts-tab-item-content"},null,this.popup.container)},switchTabs:function(a){var b=this,c;this.popup.container.querySelectorAll(".highcharts-tab-item").forEach(function(e,f){c=e.getAttribute("highcharts-data-tab-type");"edit"===c&&0===a||["click","touchstart"].forEach(function(a){d(e,a,function(){b.tabs.deselectAll.call(b);b.tabs.selectTab.call(b,
this,f)})})})},selectTab:function(a,b){var c=this.popup.container.querySelectorAll(".highcharts-tab-item-content");a.className+=" highcharts-tab-item-active";c[b].className+=" highcharts-tab-item-show"},deselectAll:function(){var a=this.popup.container,b=a.querySelectorAll(".highcharts-tab-item");a=a.querySelectorAll(".highcharts-tab-item-content");var c;for(c=0;c<b.length;c++)b[c].classList.remove("highcharts-tab-item-active"),a[c].classList.remove("highcharts-tab-item-show")}}};d(b.NavigationBindings,
"showPopup",function(a){this.popup||(this.popup=new b.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/7.1.3/gfx/stock-icons/"));this.popup.showForm(a.formType,this.chart,a.options,a.onSubmit)});d(b.NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()})});t(c,"masters/modules/annotations.src.js",[],function(){})});
//# sourceMappingURL=annotations.js.map