/*
 Highcharts JS v7.1.3 (2019-08-14)

 Sonification module

 (c) 2012-2019 ystein Moseng

 License: www.highcharts.com/license
*/
(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(n){d(n);d.Highcharts=n;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function n(b,k,m,c){b.hasOwnProperty(k)||(b[k]=c.apply(null,m))}d=d?d._modules:{};n(d,"modules/sonification/Instrument.js",[d["parts/Globals.js"]],function(b){function k(c){this.init(c)}var m={type:"oscillator",
playCallbackInterval:20,oscillator:{waveformShape:"sine"}};k.prototype.init=function(c){this.initAudioContext()?(this.options=b.merge(m,c),this.id=this.options.id=c&&c.id||b.uniqueKey(),c=b.audioContext,this.gainNode=c.createGain(),this.setGain(0),(this.panNode=c.createStereoPanner&&c.createStereoPanner())?(this.setPan(0),this.gainNode.connect(this.panNode),this.panNode.connect(c.destination)):this.gainNode.connect(c.destination),"oscillator"===this.options.type&&this.initOscillator(this.options.oscillator),
this.playCallbackTimers=[]):b.error(29)};k.prototype.copy=function(c){return new k(b.merge(this.options,{id:null},c))};k.prototype.initAudioContext=function(){var c=b.win.AudioContext||b.win.webkitAudioContext,a=!!b.audioContext;return c?(b.audioContext=b.audioContext||new c,!a&&b.audioContext&&"running"===b.audioContext.state&&b.audioContext.suspend(),!!(b.audioContext&&b.audioContext.createOscillator&&b.audioContext.createGain)):!1};k.prototype.initOscillator=function(c){this.oscillator=b.audioContext.createOscillator();
this.oscillator.type=c.waveformShape;this.oscillator.connect(this.gainNode);this.oscillatorStarted=!1};k.prototype.setPan=function(c){this.panNode&&this.panNode.pan.setValueAtTime(c,b.audioContext.currentTime)};k.prototype.setGain=function(c,a){this.gainNode&&(1.2<c&&(console.warn("Highcharts sonification warning: Volume of instrument set too high."),c=1.2),a?(this.gainNode.gain.setValueAtTime(this.gainNode.gain.value,b.audioContext.currentTime),this.gainNode.gain.linearRampToValueAtTime(c,b.audioContext.currentTime+
a/1E3)):this.gainNode.gain.setValueAtTime(c,b.audioContext.currentTime))};k.prototype.cancelGainRamp=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(0)};k.prototype.getValidFrequency=function(c,a,f){var h=this.options.allowedFrequencies,e=b.pick(f,Infinity),g=b.pick(a,-Infinity);return h&&h.length?h.reduce(function(a,b){return Math.abs(b-c)<Math.abs(a-c)&&b<e&&b>g?b:a},Infinity):c};k.prototype.clearPlayCallbackTimers=function(){this.playCallbackTimers.forEach(function(b){clearInterval(b)});
this.playCallbackTimers=[]};k.prototype.setFrequency=function(b,a){a=a||{};b=this.getValidFrequency(b,a.min,a.max);"oscillator"===this.options.type&&this.oscillatorPlay(b)};k.prototype.oscillatorPlay=function(c){this.oscillatorStarted||(this.oscillator.start(),this.oscillatorStarted=!0);this.oscillator.frequency.setValueAtTime(c,b.audioContext.currentTime)};k.prototype.preparePlay=function(){this.setGain(.001);"suspended"===b.audioContext.state&&b.audioContext.resume();this.oscillator&&!this.oscillatorStarted&&
(this.oscillator.start(),this.oscillatorStarted=!0)};k.prototype.play=function(c){var a=this,f=c.duration||0,h=function(b,e,g){var l=c.duration,f=0,h=a.options.playCallbackInterval;if("function"===typeof b){var m=setInterval(function(){f++;var c=f*h/l;if(1<=c)a[e](b(1),g),clearInterval(m);else a[e](b(c),g)},h);a.playCallbackTimers.push(m)}else a[e](b,g)};if(a.id)if("suspended"===b.audioContext.state||this.oscillator&&!this.oscillatorStarted)a.preparePlay(),setTimeout(function(){a.play(c)},10);else{a.playCallbackTimers.length&&
a.clearPlayCallbackTimers();a.cancelGainRamp();a.stopOscillatorTimeout&&(clearTimeout(a.stopOscillatorTimeout),delete a.stopOscillatorTimeout);a.stopTimeout&&(clearTimeout(a.stopTimeout),delete a.stopTimeout,a.stopCallback&&(a._play=a.play,a.play=function(){},a.stopCallback("cancelled"),a.play=a._play));var e=f<b.sonification.fadeOutDuration+20;a.stopCallback=c.onEnd;var g=function(){delete a.stopTimeout;a.stop(e)};f?(a.stopTimeout=setTimeout(g,e?f:f-b.sonification.fadeOutDuration),h(c.frequency,
"setFrequency",null,{minFrequency:c.minFrequency,maxFrequency:c.maxFrequency}),h(b.pick(c.volume,1),"setGain",4),h(b.pick(c.pan,0),"setPan")):g()}};k.prototype.mute=function(){this.setGain(.0001,.8*b.sonification.fadeOutDuration)};k.prototype.stop=function(c,a,f){var h=this,e=function(){h.stopOscillatorTimeout&&delete h.stopOscillatorTimeout;try{h.oscillator.stop()}catch(g){}h.oscillator.disconnect(h.gainNode);h.initOscillator(h.options.oscillator);a&&a(f);h.stopCallback&&h.stopCallback(f)};h.playCallbackTimers.length&&
h.clearPlayCallbackTimers();h.stopTimeout&&clearTimeout(h.stopTimeout);c?(h.setGain(0),e()):(h.mute(),h.stopOscillatorTimeout=setTimeout(e,b.sonification.fadeOutDuration+100))};return k});n(d,"modules/sonification/musicalFrequencies.js",[],function(){return[16.351597831287414,17.323914436054505,18.354047994837977,19.445436482630058,20.601722307054366,21.826764464562746,23.12465141947715,24.499714748859326,25.956543598746574,27.5,29.13523509488062,30.86770632850775,32.70319566257483,34.64782887210901,
36.70809598967594,38.890872965260115,41.20344461410875,43.653528929125486,46.2493028389543,48.999429497718666,51.91308719749314,55,58.27047018976124,61.7354126570155,65.40639132514966,69.29565774421802,73.41619197935188,77.78174593052023,82.4068892282175,87.30705785825097,92.4986056779086,97.99885899543733,103.82617439498628,110,116.54094037952248,123.47082531403103,130.8127826502993,138.59131548843604,146.8323839587038,155.56349186104046,164.81377845643496,174.61411571650194,184.9972113558172,195.99771799087463,
207.65234878997256,220,233.08188075904496,246.94165062806206,261.6255653005986,277.1826309768721,293.6647679174076,311.1269837220809,329.6275569128699,349.2282314330039,369.9944227116344,391.99543598174927,415.3046975799451,440,466.1637615180899,493.8833012561241,523.2511306011972,554.3652619537442,587.3295358348151,622.2539674441618,659.2551138257398,698.4564628660078,739.9888454232688,783.9908719634985,830.6093951598903,880,932.3275230361799,987.7666025122483,1046.5022612023945,1108.7305239074883,
1174.6590716696303,1244.5079348883237,1318.5102276514797,1396.9129257320155,1479.9776908465376,1567.981743926997,1661.2187903197805,1760,1864.6550460723597,1975.533205024496,2093.004522404789,2217.4610478149766,2349.31814333926,2489.0158697766474,2637.02045530296,2793.825851464031,2959.955381693075,3135.9634878539946,3322.437580639561,3520,3729.3100921447194,3951.066410048992,4186.009044809578]});n(d,"modules/sonification/utilities.js",[d["modules/sonification/musicalFrequencies.js"]],function(b){function k(b){this.init(b||
[])}k.prototype.init=function(b){this.supportedSignals=b;this.signals={}};k.prototype.registerSignalCallbacks=function(b){var c=this;c.supportedSignals.forEach(function(a){b[a]&&(c.signals[a]=c.signals[a]||[]).push(b[a])})};k.prototype.clearSignalCallbacks=function(b){var c=this;b?b.forEach(function(a){c.signals[a]&&delete c.signals[a]}):c.signals={}};k.prototype.emitSignal=function(b,c){var a;this.signals[b]&&this.signals[b].forEach(function(b){b=b(c);a=void 0!==b?b:a});return a};return{musicalFrequencies:b,
SignalHandler:k,getMusicalScale:function(k){return b.filter(function(b,a){var c=a%12+1;return k.some(function(b){return b===c})})},calculateDataExtremes:function(b,c){return b.series.reduce(function(b,f){f.points.forEach(function(a){a=void 0!==a[c]?a[c]:a.options[c];b.min=Math.min(b.min,a);b.max=Math.max(b.max,a)});return b},{min:Infinity,max:-Infinity})},virtualAxisTranslate:function(b,c,a){var f=c.max-c.min;b=a.min+(a.max-a.min)*(b-c.min)/f;return 0<f?Math.max(Math.min(b,a.max),a.min):a.min}}});
n(d,"modules/sonification/instrumentDefinitions.js",[d["modules/sonification/Instrument.js"],d["modules/sonification/utilities.js"]],function(b,k){var d={};["sine","square","triangle","sawtooth"].forEach(function(c){d[c]=new b({oscillator:{waveformShape:c}});d[c+"Musical"]=new b({allowedFrequencies:k.musicalFrequencies,oscillator:{waveformShape:c}});d[c+"Major"]=new b({allowedFrequencies:k.getMusicalScale([1,3,5,6,8,10,12]),oscillator:{waveformShape:c}})});return d});n(d,"modules/sonification/Earcon.js",
[d["parts/Globals.js"]],function(b){function d(b){this.init(b||{})}d.prototype.init=function(d){this.options=d;this.options.id||(this.options.id=this.id=b.uniqueKey());this.instrumentsPlaying={}};d.prototype.sonify=function(d){var c=b.merge(this.options,d),a=b.pick(c.volume,1),f=c.pan,h=this,e=d&&d.onEnd,g=h.options.onEnd;c.instruments.forEach(function(c){var d="string"===typeof c.instrument?b.sonification.instruments[c.instrument]:c.instrument,l=b.merge(c.playOptions);if(d&&d.play){if(c.playOptions){"function"!==
typeof c.playOptions.volume&&(l.volume=b.pick(a,1)*b.pick(c.playOptions.volume,1));l.pan=b.pick(f,l.pan);var k=l.onEnd;l.onEnd=function(){delete h.instrumentsPlaying[p];k&&k.apply(this,arguments);Object.keys(h.instrumentsPlaying).length||(e&&e.apply(this,arguments),g&&g.apply(this,arguments))};c=d.copy();var p=c.id;h.instrumentsPlaying[p]=c;c.play(l)}}else b.error(30)})};d.prototype.cancelSonify=function(b){var c=this.instrumentsPlaying,a=c&&Object.keys(c);a&&a.length&&(a.forEach(function(a){c[a].stop(!b,
null,"cancelled")}),this.instrumentsPlaying={})};return d});n(d,"modules/sonification/pointSonify.js",[d["parts/Globals.js"],d["modules/sonification/utilities.js"]],function(b,d){var k={minDuration:20,maxDuration:2E3,minVolume:.1,maxVolume:1,minPan:-1,maxPan:1,minFrequency:220,maxFrequency:2200};return{pointSonify:function(c){var a=this,f=a.series.chart,h=c.dataExtremes||{},e=function(c,e,g,f){if("number"===typeof c||void 0===c)return c;if("function"===typeof c)return e?function(b){return c(a,h,b)}:
c(a,h);if("string"===typeof c)return h[c]=h[c]||d.calculateDataExtremes(a.series.chart,c),d.virtualAxisTranslate(b.pick(a[c],a.options[c]),h[c],g,f)};f.sonification.currentlyPlayingPoint=a;a.sonification=a.sonification||{};a.sonification.instrumentsPlaying=a.sonification.instrumentsPlaying||{};var g=a.sonification.signalHandler=a.sonification.signalHandler||new d.SignalHandler(["onEnd"]);g.clearSignalCallbacks();g.registerSignalCallbacks({onEnd:c.onEnd});!a.isNull&&a.visible&&a.series.visible?c.instruments.forEach(function(c){var d=
"string"===typeof c.instrument?b.sonification.instruments[c.instrument]:c.instrument,h=c.instrumentMapping||{},l=b.merge(k,c.instrumentOptions),p=d.id,m=function(b){c.onEnd&&c.onEnd.apply(this,arguments);f.sonification&&f.sonification.currentlyPlayingPoint&&delete f.sonification.currentlyPlayingPoint;a.sonification&&a.sonification.instrumentsPlaying&&(delete a.sonification.instrumentsPlaying[p],Object.keys(a.sonification.instrumentsPlaying).length||g.emitSignal("onEnd",b))};d&&d.play?(a.sonification.instrumentsPlaying[d.id]=
d,d.play({frequency:e(h.frequency,!0,{min:l.minFrequency,max:l.maxFrequency}),duration:e(h.duration,!1,{min:l.minDuration,max:l.maxDuration}),pan:e(h.pan,!0,{min:l.minPan,max:l.maxPan}),volume:e(h.volume,!0,{min:l.minVolume,max:l.maxVolume}),onEnd:m,minFrequency:l.minFrequency,maxFrequency:l.maxFrequency})):b.error(30)}):g.emitSignal("onEnd")},pointCancelSonify:function(b){var c=this.sonification&&this.sonification.instrumentsPlaying,d=c&&Object.keys(c);d&&d.length&&(d.forEach(function(a){c[a].stop(!b,
null,"cancelled")}),this.sonification.instrumentsPlaying={},this.sonification.signalHandler.emitSignal("onEnd","cancelled"))}}});n(d,"modules/sonification/chartSonify.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["modules/sonification/utilities.js"]],function(b,d,m){function c(c,a){return"function"===typeof a?a(c):b.pick(c[a],c.options[a])}function a(b,a){return b.points.reduce(function(b,e){e=c(e,a);b.min=Math.min(b.min,e);b.max=Math.max(b.max,e);return b},{min:Infinity,max:-Infinity})}function f(c,
a,e){return(a||[]).reduce(function(b,a){Object.keys(a.instrumentMapping||{}).forEach(function(e){e=a.instrumentMapping[e];"string"!==typeof e||b[e]||(b[e]=m.calculateDataExtremes(c,e))});return b},b.merge(e))}function h(c,a){return a.reduce(function(a,e){var d=e.earcon;e.condition?(e=e.condition(c),e instanceof b.sonification.Earcon?a.push(e):e&&a.push(d)):e.onPoint&&c.id===e.onPoint&&a.push(d);return a},[])}function e(c){return c.map(function(c){var a=c.instrument;a=("string"===typeof a?b.sonification.instruments[a]:
a).copy();return b.merge(c,{instrument:a})})}function g(d,g){var l=g.timeExtremes||a(d,g.pointPlayTime,g.dataExtremes),w=f(d.chart,g.instruments,g.dataExtremes),k=e(g.instruments),x=d.points.reduce(function(a,e){var d=h(e,g.earcons||[]),f=m.virtualAxisTranslate(c(e,g.pointPlayTime),l,{min:0,max:g.duration});return a.concat(new b.sonification.TimelineEvent({eventObject:e,time:f,id:e.id,playOptions:{instruments:k,dataExtremes:w}}),d.map(function(a){return new b.sonification.TimelineEvent({eventObject:a,
time:f})}))},[]);return new b.sonification.TimelinePath({events:x,onStart:function(){if(g.onStart)g.onStart(d)},onEventStart:function(a){var c=a.options&&a.options.eventObject;if(c instanceof b.Point){if(!c.series.visible&&!c.series.chart.series.some(function(b){return b.visible}))return a.timelinePath.timeline.pause(),a.timelinePath.timeline.resetCursor(),!1;if(g.onPointStart)g.onPointStart(a,c)}},onEventEnd:function(a){var c=a.event&&a.event.options&&a.event.options.eventObject;if(c instanceof b.Point&&
g.onPointEnd)g.onPointEnd(a.event,c)},onEnd:function(){if(g.onEnd)g.onEnd(d)}})}function l(c,e,d){var g=d.seriesOptions||{};return b.merge({dataExtremes:e,timeExtremes:a(c,d.pointPlayTime),instruments:d.instruments,onStart:d.onSeriesStart,onEnd:d.onSeriesEnd,earcons:d.earcons},u(g)?b.find(g,function(a){return a.id===b.pick(c.id,c.options.id)})||{}:g,{pointPlayTime:d.pointPlayTime})}function k(a,c,e){if("sequential"===a||"simultaneous"===a){var d=c.series.reduce(function(a,b){b.visible&&a.push({series:b,
seriesOptions:e(b)});return a},[]);"simultaneous"===a&&(d=[d])}else d=a.reduce(function(a,d){d=q(d).reduce(function(a,d){var g;if("string"===typeof d){var f=c.get(d);f.visible&&(g={series:f,seriesOptions:e(f)})}else d instanceof b.sonification.Earcon&&(g=new b.sonification.TimelinePath({events:[new b.sonification.TimelineEvent({eventObject:d})]}));d.silentWait&&(g=new b.sonification.TimelinePath({silentWait:d.silentWait}));g&&a.push(g);return a},[]);d.length&&a.push(d);return a},[]);return d}function n(a,
c){return c?a.reduce(function(e,d,g){d=q(d);e.push(d);g<a.length-1&&d.some(function(a){return a.series})&&e.push(new b.sonification.TimelinePath({silentWait:c}));return e},[]):a}function r(a){return a.reduce(function(a,b){b=q(b);return a+(1===b.length&&b[0].options&&b[0].options.silentWait||0)},0)}function p(a){var c=a.reduce(function(a,b){(b=b.events)&&b.length&&(a.min=Math.min(b[0].time,a.min),a.max=Math.max(b[b.length-1].time,a.max));return a},{min:Infinity,max:-Infinity});a.forEach(function(a){var e=
a.events,d=e&&e.length,g=[];d&&e[0].time<=c.min||g.push(new b.sonification.TimelineEvent({time:c.min}));d&&e[e.length-1].time>=c.max||g.push(new b.sonification.TimelineEvent({time:c.max}));g.length&&a.addTimelineEvents(g)})}function t(a){return a.reduce(function(a,b){return a+q(b).reduce(function(a,b){return(b=b.series&&b.seriesOptions&&b.seriesOptions.timeExtremes)?Math.max(a,b.max-b.min):a},0)},0)}function v(a,c){var e=Math.max(c-r(a),0),d=t(a);return a.reduce(function(a,c){c=q(c).reduce(function(a,
c){c instanceof b.sonification.TimelinePath?a.push(c):c.series&&(c.seriesOptions.duration=c.seriesOptions.duration||m.virtualAxisTranslate(c.seriesOptions.timeExtremes.max-c.seriesOptions.timeExtremes.min,{min:0,max:d},{min:0,max:e}),a.push(g(c.series,c.seriesOptions)));return a},[]);a.push(c);return a},[])}var u=d.isArray,q=d.splat;return{chartSonify:function(a){this.sonification.timeline&&this.sonification.timeline.pause();var c=f(this,a.instruments,a.dataExtremes),e=k(a.order,this,function(b){return l(b,
c,a)});e=n(e,a.afterSeriesWait||0);e=v(e,a.duration);e.forEach(function(a){p(a)});this.sonification.timeline=new b.sonification.Timeline({paths:e,onEnd:a.onEnd});this.sonification.timeline.play()},seriesSonify:function(a){a=g(this,a);var c=this.chart.sonification;c.timeline&&c.timeline.pause();c.timeline=new b.sonification.Timeline({paths:[a]});c.timeline.play()},pause:function(a){this.sonification.timeline?this.sonification.timeline.pause(b.pick(a,!0)):this.sonification.currentlyPlayingPoint&&this.sonification.currentlyPlayingPoint.cancelSonify(a)},
resume:function(a){this.sonification.timeline&&this.sonification.timeline.play(a)},rewind:function(a){this.sonification.timeline&&this.sonification.timeline.rewind(a)},cancel:function(a){this.pauseSonify(a);this.resetSonifyCursor()},getCurrentPoints:function(){if(this.sonification.timeline){var a=this.sonification.timeline.getCursor();return Object.keys(a).map(function(b){return a[b].eventObject}).filter(function(a){return a instanceof b.Point})}return[]},setCursor:function(a){var b=this.sonification.timeline;
b&&q(a).forEach(function(a){b.setCursor(a.id)})},resetCursor:function(){this.sonification.timeline&&this.sonification.timeline.resetCursor()},resetCursorEnd:function(){this.sonification.timeline&&this.sonification.timeline.resetCursorEnd()}}});n(d,"modules/sonification/Timeline.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["modules/sonification/utilities.js"]],function(b,d,m){function c(a){this.init(a||{})}function a(a){this.init(a)}function f(a){this.init(a||{})}var h=d.splat;c.prototype.init=
function(a){this.options=a;this.time=a.time||0;this.id=this.options.id=a.id||b.uniqueKey()};c.prototype.play=function(a){var c=this.options.eventObject,e=this.options.onEnd,d=a&&a.onEnd,f=this.options.playOptions&&this.options.playOptions.onEnd;a=b.merge(this.options.playOptions,a);c&&c.sonify?(a.onEnd=e||d||f?function(){var a=arguments;[e,d,f].forEach(function(b){b&&b.apply(this,a)})}:void 0,c.sonify(a)):(d&&d(),e&&e())};c.prototype.cancel=function(a){this.options.eventObject.cancelSonify(a)};a.prototype.init=
function(a){this.options=a;this.id=this.options.id=a.id||b.uniqueKey();this.cursor=0;this.eventsPlaying={};this.events=a.silentWait?[new c({time:0}),new c({time:a.silentWait})]:this.options.events;this.sortEvents();this.updateEventIdMap();this.signalHandler=new m.SignalHandler(["playOnEnd","masterOnEnd","onStart","onEventStart","onEventEnd"]);this.signalHandler.registerSignalCallbacks(b.merge(a,{masterOnEnd:a.onEnd}))};a.prototype.sortEvents=function(){this.events=this.events.sort(function(a,b){return a.time-
b.time})};a.prototype.updateEventIdMap=function(){this.eventIdMap=this.events.reduce(function(a,b,c){a[b.id]=c;return a},{})};a.prototype.addTimelineEvents=function(a){this.events=this.events.concat(a);this.sortEvents();this.updateEventIdMap()};a.prototype.getCursor=function(){return this.events[this.cursor]};a.prototype.setCursor=function(a){a=this.eventIdMap[a];return void 0!==a?(this.cursor=a,!0):!1};a.prototype.play=function(a){this.pause();this.signalHandler.emitSignal("onStart");this.signalHandler.clearSignalCallbacks(["playOnEnd"]);
this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playEvents(1)};a.prototype.rewind=function(a){this.pause();this.signalHandler.emitSignal("onStart");this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playEvents(-1)};a.prototype.resetCursor=function(){this.cursor=0};a.prototype.resetCursorEnd=function(){this.cursor=this.events.length-1};a.prototype.pause=function(a){var b=this;clearTimeout(b.nextScheduledPlay);Object.keys(b.eventsPlaying).forEach(function(c){b.eventsPlaying[c]&&
b.eventsPlaying[c].cancel(a)});b.eventsPlaying={}};a.prototype.playEvents=function(a){var b=this,c=b.events[this.cursor],d=b.events[this.cursor+a],e=function(a){b.signalHandler.emitSignal("masterOnEnd",a);b.signalHandler.emitSignal("playOnEnd",a)};c.timelinePath=b;if(!1===b.signalHandler.emitSignal("onEventStart",c))e({event:c,cancelled:!0});else if(b.eventsPlaying[c.id]=c,c.play({onEnd:function(a){a={event:c,cancelled:!!a};delete b.eventsPlaying[c.id];b.signalHandler.emitSignal("onEventEnd",a);d||
e(a)}}),d){var f=Math.abs(d.time-c.time);1>f?(b.cursor+=a,b.playEvents(a)):this.nextScheduledPlay=setTimeout(function(){b.cursor+=a;b.playEvents(a)},f)}};f.prototype.init=function(a){this.options=a;this.cursor=0;this.paths=a.paths;this.pathsPlaying={};this.signalHandler=new m.SignalHandler(["playOnEnd","masterOnEnd","onPathStart","onPathEnd"]);this.signalHandler.registerSignalCallbacks(b.merge(a,{masterOnEnd:a.onEnd}))};f.prototype.play=function(a){this.pause();this.signalHandler.clearSignalCallbacks(["playOnEnd"]);
this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playPaths(1)};f.prototype.rewind=function(a){this.pause();this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playPaths(-1)};f.prototype.playPaths=function(a){var c=h(this.paths[this.cursor]),d=this.paths[this.cursor+a],e=this,f=this.signalHandler,k=0,m=function(b){f.emitSignal("onPathStart",b);e.pathsPlaying[b.id]=b;b[0<a?"play":"rewind"](function(g){g=g&&g.cancelled;var l=
{path:b,cancelled:g};delete e.pathsPlaying[b.id];f.emitSignal("onPathEnd",l);k++;k>=c.length&&(d&&!g?(e.cursor+=a,h(d).forEach(function(b){b[0<a?"resetCursor":"resetCursorEnd"]()}),e.playPaths(a)):(f.emitSignal("playOnEnd",l),f.emitSignal("masterOnEnd",l)))})};c.forEach(function(a){a&&(a.timeline=e,setTimeout(function(){m(a)},b.sonification.fadeOutTime))})};f.prototype.pause=function(a){var b=this;Object.keys(b.pathsPlaying).forEach(function(c){b.pathsPlaying[c]&&b.pathsPlaying[c].pause(a)});b.pathsPlaying=
{}};f.prototype.resetCursor=function(){this.paths.forEach(function(a){h(a).forEach(function(a){a.resetCursor()})});this.cursor=0};f.prototype.resetCursorEnd=function(){this.paths.forEach(function(a){h(a).forEach(function(a){a.resetCursorEnd()})});this.cursor=this.paths.length-1};f.prototype.setCursor=function(a){return this.paths.some(function(b){return h(b).some(function(b){return b.setCursor(a)})})};f.prototype.getCursor=function(){return this.getCurrentPlayingPaths().reduce(function(a,b){a[b.id]=
b.getCursor();return a},{})};f.prototype.atStart=function(){return!this.getCurrentPlayingPaths().some(function(a){return a.cursor})};f.prototype.getCurrentPlayingPaths=function(){return h(this.paths[this.cursor])};return{TimelineEvent:c,TimelinePath:a,Timeline:f}});n(d,"modules/sonification/sonification.js",[d["parts/Globals.js"],d["modules/sonification/Instrument.js"],d["modules/sonification/instrumentDefinitions.js"],d["modules/sonification/Earcon.js"],d["modules/sonification/pointSonify.js"],d["modules/sonification/chartSonify.js"],
d["modules/sonification/utilities.js"],d["modules/sonification/Timeline.js"]],function(b,d,m,c,a,f,h,e){b.sonification={fadeOutDuration:20,utilities:h,Instrument:d,instruments:m,Earcon:c,TimelineEvent:e.TimelineEvent,TimelinePath:e.TimelinePath,Timeline:e.Timeline};b.Point.prototype.sonify=a.pointSonify;b.Point.prototype.cancelSonify=a.pointCancelSonify;b.Series.prototype.sonify=f.seriesSonify;b.extend(b.Chart.prototype,{sonify:f.chartSonify,pauseSonify:f.pause,resumeSonify:f.resume,rewindSonify:f.rewind,
cancelSonify:f.cancel,getCurrentSonifyPoints:f.getCurrentPoints,setSonifyCursor:f.setCursor,resetSonifyCursor:f.resetCursor,resetSonifyCursorEnd:f.resetCursorEnd,sonification:{}})});n(d,"masters/modules/sonification.src.js",[],function(){})});
//# sourceMappingURL=sonification.js.map